package com.xebialabs.xlrelease.reports.audit

import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.planner.PlannerReleaseItem
import com.xebialabs.xlrelease.reports.audit.CommonFormat.TaskAgent
import com.xebialabs.xlrelease.reports.audit.ReleaseOverviewReport._
import com.xebialabs.xlrelease.reports.domain.MaybeData
import com.xebialabs.xlrelease.reports.excel.{ErrorHandler, ExcelStyles}

object CommonTaskReportSheet {
  val COLUMNS = Seq(
    PHASE_COLUMN,
    TASK_COLUMN,
    TYPE_COLUMN,
    STATUS_COLUMN,
    START_DATE_COLUMN,
    END_DATE_COLUMN,
    DURATION_COLUMN,
    ASSIGNED_USER_COLUMN,
    ASSIGNED_TEAM_COLUMN,
    COMPLETED_BY_COLUMN
  )
}

trait CommonTaskReportSheet {
  self: ErrorHandler =>

  def styles: ExcelStyles

  def addTaskCommonHeader(): Unit = {
    CommonTaskReportSheet.COLUMNS.foreach(sheetWriter.addHeaderCell(_, styles.whiteOnGreen))
  }

  def addTaskCommonCells(plannedTask: PlannerReleaseItem,
                         release: Release, taskAgent: TaskAgent,
                         printPhaseTitle: Boolean = true,
                         includeDescription: Boolean = false): Option[(Int, Int)] = {
    plannedTask.getTask.map { task =>

      if (printPhaseTitle) addCellForMaybe(MaybeData.nonEmptyString(task.getPhase.getTitle)) else sheetWriter.addEmptyCell(styles.default)
      val result = (sheetWriter.getRowIndex - 1) -> sheetWriter.getColumnIndex
      addCellForMaybe(MaybeData.nonEmptyString(CommonFormat.getPlanItemTitle(release, task)))
      if (includeDescription) addCellForMaybe(MaybeData.allowingNull(task.getDescription), styles.wrapped)
      addCellForMaybe(MaybeData.nonEmptyString(CommonFormat.getTaskType(task)))
      addCellForMaybe(MaybeData.nonEmptyString(CommonFormat.prettifyStatusString(task.getStatus.value())))
      addCellForMaybe(MaybeData.allowingNull(plannedTask.getStartDate))
      addCellForMaybe(MaybeData.allowingNull(plannedTask.getEndDate).orElse(MaybeData.allowingNull(plannedTask.getDueDate)))
      if (plannedTask.getItem().hasEndDate) {
        addCellForMaybe(MaybeData.allowingNull(plannedTask.getItem().getActualDuration))
      } else {
        addCellForMaybe(MaybeData.allowingNull(plannedTask.getDuration))
      }

      val (assignedUser, assignedTeam) = taskAgent.assignedUserAndTeam
      sheetWriter
        .addCell(assignedUser.getOrElse(""))
        .addCell(assignedTeam.getOrElse(""))
        .addCell(taskAgent.completedBy.getOrElse(""))
      result
    }
  }
}
