package com.xebialabs.xlrelease.reports.audit

import com.xebialabs.xlrelease.reports.filters.CompositeFilter.Operator._
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.udm.reporting.filters._
import com.xebialabs.xlrelease.udm.reporting.filters.impl._

import scala.beans.BeanProperty
import scala.collection.mutable
import scala.jdk.CollectionConverters._

class UserPermissionsReportFilterVisitor extends UdmReportFilterVisitor[Boolean] {

  @BeanProperty
  var folderlessFolderId: String = _

  private val orFilterCache: mutable.Map[CompositeFilter, Option[Set[String]]] = new mutable.HashMap
  private def notApplicable = throw new IllegalArgumentException("This filter is not applicable to User Permissions Report")

  override def visit(filter: DateFilter): Boolean = notApplicable
  override def visit(filter: TagsFilter): Boolean = notApplicable
  override def visit(filter: TemplateFilter): Boolean = notApplicable
  override def visit(filter: ApplicationFilter): Boolean = notApplicable
  override def visit(filter: EnvironmentFilter): Boolean = notApplicable
  override def visit(filter: EnvironmentLabelFilter): Boolean = notApplicable
  override def visit(filter: EnvironmentStageFilter): Boolean = notApplicable
  override def visit(filter: ReleaseFilter): Boolean = notApplicable
  override def visit(filter: ChangeNumbersFilter): Boolean = notApplicable
  override def visit(filter: ApplicationNamesFilter): Boolean = notApplicable

  override def visit(filter: EnvironmentNamesFilter): Boolean = notApplicable

  override def visit(filter: ReleaseStatusFilter): Boolean = notApplicable
  override def visit(filter: RiskFilter): Boolean = notApplicable

  override def visit(filter: CompositeFilter): Boolean = {
    // optimize this a bit, so, that for simple construction that is OR or few folder filters
    // we can get performance benefit by using Set
    if (!orFilterCache.contains(filter)) {
      if (filter.getOperator == OR && !filter.getFilters.asScala.exists(!_.isInstanceOf[FolderFilter])) {
        orFilterCache.put(
          filter,
          Some(filter.getFilters.asScala
            .map(_.asInstanceOf[FolderFilter].getFolderId)
            .map(Ids.getName)
            .toSet))
      } else {
        orFilterCache.put(filter, None)
      }
    }
    orFilterCache.get(filter).get match {
      case Some(folderSet) => folderSet.contains(folderlessFolderId)
      case _ => {
        val filters = filter.getFilters.asScala.map(_.asInstanceOf[UdmReportFilter])
        filter.getOperator match {
          case AND => filters.forall(filter => filter.accept(this))
          case OR => filters.exists(filter => filter.accept(this))
        }
      }
    }
  }
  override def visit(filter: FolderFilter): Boolean = {
    filter.getFolderId == folderlessFolderId
  }
}
