package com.xebialabs.xlrelease.reports.excel;

import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xebialabs.xlrelease.reports.api.internal.ReportResource;
import com.xebialabs.xlrelease.reports.dto.PhaseDuration;
import com.xebialabs.xlrelease.reports.dto.ReleaseDuration;
import com.xebialabs.xlrelease.reports.dto.TaskDuration;
import com.xebialabs.xlrelease.reports.dto.UserParticipation;
import com.xebialabs.xlrelease.reports.service.ReportParams;
import com.xebialabs.xlrelease.reports.service.ReportServiceCache;


@Service
public class ReportExcel {

    private ReportServiceCache reportService;

    @Autowired
    public ReportExcel(ReportServiceCache reportService) {
        this.reportService = reportService;
    }

    public Workbook getWorkBook(ReportResource.ReportType report, ReportParams reportParams) {
        switch (report) {
            case TOP_LONGEST_RELEASE:
                return exportTopLongestRelease(reportParams);
            case TOP_LONGEST_PHASE:
                return exportTopLongestPhase(reportParams);
            case TOP_LONGEST_TASK:
                return exportTopLongestTask(reportParams);
            case TOP_PEOPLE_MOST_INVOLVED:
                return exportTopPeopleMostInvolved(reportParams);
            default:
                throw new IllegalArgumentException("Can't generate excel for report " + report.name());
        }
    }

    private Workbook exportTopLongestRelease(ReportParams reportParams) {
        List<ReleaseDuration> topLongestReleases = reportService.getReleaseDuration(reportParams).getLongestReleases();
        return new TopLongestReleaseExport(topLongestReleases).getWorkBook();
    }

    private Workbook exportTopLongestPhase(ReportParams reportParams) {
        List<PhaseDuration> topLongestPhases = reportService.getTopLongestPhases(reportParams);
        return new TopLongestPhaseExport(topLongestPhases).getWorkBook();
    }

    private Workbook exportTopLongestTask(ReportParams reportParams) {
        List<TaskDuration> topLongestTasks = reportService.getTopLongestTasks(reportParams);
        return new TopLongestTaskExport(topLongestTasks).getWorkBook();
    }

    private Workbook exportTopPeopleMostInvolved(ReportParams reportParams) {
        List<UserParticipation> topPeopleMostInvolved = reportService.getTopPeopleMostInvolved(reportParams);
        return new TopPeopleMostInvolvedExport(topPeopleMostInvolved).getWorkBook();
    }
}
