package com.xebialabs.xlrelease.reports.job.api

import com.xebialabs.xlrelease.reports.job.domain.{ReportJob, ReportJobStatus}
import com.xebialabs.xlrelease.reports.job.repository.ReportJobFilters
import org.springframework.data.domain.{Page, Pageable}

import java.util.{List => JList}

trait ReportingEngineService {

  import ReportingEngineService._

  // async run
  def submit(reportDefinition: ReportDefinition): ReportJobId

  def preview(reportDefinition: ReportDefinition): Any

  def getResult(ReportJobId: ReportJobId): StreamingReportResult

  def status(ReportJobId: ReportJobId): ReportJobStatus

  def get(ReportJobId: ReportJobId): ReportJob

  def abort(ReportJobId: ReportJobId): Unit

  def abort(jobIds: JList[ReportJobId]): JList[ReportJobId]

  def abortAll(): JList[ReportJobId]

  def delete(ReportJobId: ReportJobId): Unit

  def delete(jobIds: JList[ReportJobId]): JList[ReportJobId]

  def deleteAll(): JList[ReportJobId]

  def findBy(reportJobFilters: ReportJobFilters, pageable: Pageable): Page[ReportJob]

}

object ReportingEngineService {
  type ReportJobId = Integer
}
