package com.xebialabs.xlrelease.reports.repository

import com.xebialabs.xlrelease.api.v1.forms.FacetFilters
import com.xebialabs.xlrelease.domain.facet.{Facet, TaskReportingRecord}
import com.xebialabs.xlrelease.repository.FacetRepository.SpecializedFacetRepository
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport
import com.xebialabs.xlrelease.repository.sql.persistence.Utils.params
import org.springframework.jdbc.core.RowMapper

import scala.collection.mutable
import scala.jdk.CollectionConverters._

trait SearchRecordsSupport[T <: TaskReportingRecord] extends PersistenceSupport {
  self: SpecializedFacetRepository =>
  protected def findAllFacetsByTargetId(targetId: CiId): mutable.Seq[T]

  protected def findAllFacetsByReleaseId(releaseId: CiId): mutable.Seq[T]

  def searchRecords(facetsFilters: FacetFilters, searchAllRecordsSql: String, rowMapper: RowMapper[T]): Seq[Facet] = {
    val types = if (facetsFilters.getTypes.isEmpty) {
      Seq(supportedType)
    } else {
      facetsFilters.getTypes.asScala.filter(_.instanceOf(supportedType))
    }
    val byTargetId = Option(facetsFilters.getTargetId)
    val byParentId = Option(facetsFilters.getParentId)
    val facets = (byTargetId, byParentId) match {
      case (None, None) =>
        sqlQuery(searchAllRecordsSql, params(), rowMapper)
      case (Some(targetId), _) =>
        findAllFacetsByTargetId(targetId)
      case (None, Some(parentId)) =>
        findAllFacetsByReleaseId(parentId)
    }
    facets.filter(f => types.exists(f.getType.instanceOf)).toSeq
  }
}
