/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.job.impl.cleanup;

import akka.actor.ActorRef;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.configuration.AuditReportSettings;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.domain.ReportJobStatus;
import com.xebialabs.xlrelease.reports.job.events.ReportJobDeletedEvent;
import com.xebialabs.xlrelease.reports.job.impl.GlobalReportStorage;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobDelegateActor;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobDelegateActorHolder;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstance;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstanceFactory;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobFilters;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.threeten.extra.Interval;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\n\u0015\u0001\rB\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\ts\u0001\u0011\t\u0011)A\u0005u!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u000bM\u0003A\u0011\u0001+\t\u0011u\u0003\u0001R1A\u0005\u0002yCqa\u001a\u0001C\u0002\u0013\u0005\u0001\u000e\u0003\u0004r\u0001\u0001\u0006I!\u001b\u0005\u0006+\u0001!\tA\u001d\u0005\u0006m\u0002!\ta\u001e\u0005\b\u0003\u0017\u0001A\u0011\u0001\fs\u0011\u0019\ti\u0001\u0001C\u0005e\"9\u0011q\u0002\u0001\u0005\n\u0005E\u0001bBA!\u0001\u0011%\u00111\t\u0005\b\u0003\u000f\u0002A\u0011BA%\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001f\u0012qCU3q_J$8\t\\3b]\u0016\u0014x\n]3sCRLwN\\:\u000b\u0005U1\u0012aB2mK\u0006tW\u000f\u001d\u0006\u0003/a\tA![7qY*\u0011\u0011DG\u0001\u0004U>\u0014'BA\u000e\u001d\u0003\u001d\u0011X\r]8siNT!!\b\u0010\u0002\u0013ad'/\u001a7fCN,'BA\u0010!\u0003%AXMY5bY\u0006\u00147OC\u0001\"\u0003\r\u0019w.\\\u0002\u0001'\r\u0001AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013!B:mMRR'\"A\u0018\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\r\u0017\u0003\u000f1{wmZ5oO\u0006\u0019\"/\u001a9peRTuN\u0019*fa>\u001c\u0018\u000e^8ssB\u0011AgN\u0007\u0002k)\u0011a\u0007G\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u001d6\u0005M\u0011V\r]8si*{'MU3q_NLGo\u001c:z\u0003a\u0011X\r]8si*{'-\u00138ti\u0006t7-\u001a$bGR|'/\u001f\t\u0003wqj\u0011AF\u0005\u0003{Y\u0011\u0001DU3q_J$(j\u001c2J]N$\u0018M\\2f\r\u0006\u001cGo\u001c:z\u0003]\u0019wN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002A\u00056\t\u0011I\u0003\u000279%\u00111)\u0011\u0002\u0018\u0007>tg-[4ve\u0006$\u0018n\u001c8SKB|7/\u001b;pef\f1c\u001a7pE\u0006d'+\u001a9peR\u001cFo\u001c:bO\u0016\u0004\"a\u000f$\n\u0005\u001d3\"aE$m_\n\fGNU3q_J$8\u000b^8sC\u001e,\u0017\u0001\b:fa>\u0014HOS8c\t\u0016dWmZ1uK\u0006\u001bGo\u001c:I_2$WM\u001d\t\u0003w)K!a\u0013\f\u00039I+\u0007o\u001c:u\u0015>\u0014G)\u001a7fO\u0006$X-Q2u_JDu\u000e\u001c3fe\u0006AQM^3oi\n+8\u000f\u0005\u0002O#6\tqJ\u0003\u0002Q9\u00051QM^3oiNL!AU(\u0003#ac%+\u001a7fCN,WI^3oi\n+8/\u0001\u0004=S:LGO\u0010\u000b\b+^C\u0016LW.]!\t1\u0006!D\u0001\u0015\u0011\u0015\u0011t\u00011\u00014\u0011\u0015It\u00011\u0001;\u0011\u0015qt\u00011\u0001@\u0011\u0015!u\u00011\u0001F\u0011\u0015Au\u00011\u0001J\u0011\u0015au\u00011\u0001N\u0003Y\u0011X\r]8si*{'\rR3mK\u001e\fG/Z!di>\u0014X#A0\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017!B1di>\u0014(\"\u00013\u0002\t\u0005\\7.Y\u0005\u0003M\u0006\u0014\u0001\"Q2u_J\u0014VMZ\u0001\u0013S:LG/[1mSj\fG/[8o)&lW-F\u0001j!\tQw.D\u0001l\u0015\taW.\u0001\u0003vi&d'\"\u00018\u0002\t)\fg/Y\u0005\u0003a.\u0014A\u0001R1uK\u0006\u0019\u0012N\\5uS\u0006d\u0017N_1uS>tG+[7fAQ\t1\u000f\u0005\u0002&i&\u0011QO\n\u0002\u0005+:LG/A\u0006o_\u0012,7\t\\3b]V\u0004HCA:y\u0011\u0015IH\u00021\u0001{\u0003\u0011qw\u000eZ3\u0011\u0007m\f)AD\u0002}\u0003\u0003\u0001\"! \u0014\u000e\u0003yT!a \u0012\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019AJ\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0011\u0011\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\ra%A\u0007ti\u0006$Xo]\"mK\u0006tW\u000f]\u0001\u000fgR|'/Y4f\u00072,\u0017M\\;q\u0003-1\u0017-\u001b7O_\u0012,'j\u001c2\u0015\u0007M\f\u0019\u0002C\u0004\u0002\u0016=\u0001\r!a\u0006\u0002\u000b)|'-\u00133\u0011\t\u0005e\u00111\b\b\u0005\u00037\t)D\u0004\u0003\u0002\u001e\u0005Eb\u0002BA\u0010\u0003_qA!!\t\u0002.9!\u00111EA\u0016\u001d\u0011\t)#!\u000b\u000f\u0007u\f9#C\u0001\"\u0013\ty\u0002%\u0003\u0002\u001e=%\u00111\u0004H\u0005\u00033iI1!a\r\u0019\u0003\r\t\u0007/[\u0005\u0005\u0003o\tI$\u0001\fSKB|'\u000f^5oO\u0016sw-\u001b8f'\u0016\u0014h/[2f\u0015\r\t\u0019\u0004G\u0005\u0005\u0003{\tyDA\u0006SKB|'\u000f\u001e&pE&#'\u0002BA\u001c\u0003s\tqA]3rk\u0016,X\rF\u0002t\u0003\u000bBq!!\u0006\u0011\u0001\u0004\t9\"\u0001\u0007gC&d7\u000b^1mK*{'\rF\u0002t\u0003\u0017Bq!!\u0006\u0012\u0001\u0004\t9\"\u0001\u0003gC&dG#B:\u0002R\u0005M\u0003bBA\u000b%\u0001\u0007\u0011q\u0003\u0005\u0007\u0003+\u0012\u0002\u0019\u0001>\u0002\u00075\u001cx\r")
public class ReportCleanerOperations
implements Logging {
    private ActorRef reportJobDelegateActor;
    private final ReportJobRepository reportJobRepository;
    private final ReportJobInstanceFactory reportJobInstanceFactory;
    private final ConfigurationRepository configurationRepository;
    private final GlobalReportStorage globalReportStorage;
    private ReportJobDelegateActorHolder reportJobDelegateActorHolder;
    private final XLReleaseEventBus eventBus;
    private final Date initializationTime;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportCleanerOperations reportCleanerOperations = this;
        synchronized (reportCleanerOperations) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private ActorRef reportJobDelegateActor$lzycompute() {
        ReportCleanerOperations reportCleanerOperations = this;
        synchronized (reportCleanerOperations) {
            if (!this.bitmap$0) {
                this.reportJobDelegateActor = this.reportJobDelegateActorHolder.actorRef();
                this.bitmap$0 = true;
            }
        }
        this.reportJobDelegateActorHolder = null;
        return this.reportJobDelegateActor;
    }

    public ActorRef reportJobDelegateActor() {
        return !this.bitmap$0 ? this.reportJobDelegateActor$lzycompute() : this.reportJobDelegateActor;
    }

    public Date initializationTime() {
        return this.initializationTime;
    }

    public void cleanup() {
        this.statusCleanup();
        this.storageCleanup();
    }

    public void nodeCleanup(String node) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(39).append("Report status cleanup for node ").append(node).append(" started").toString());
        if (Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.reportJobRepository.startedNodeJobIds(node).foreach((Function1 & Serializable)jobId -> {
            this.failNodeJob(jobId);
            return BoxedUnit.UNIT;
        })).isFailure()) {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(48).append("Report status cleanup failed for jobs on node '").append(node).append("'").toString());
        }
        if (Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.reportJobRepository.submittedNodeJobIds(node).foreach((Function1 & Serializable)jobId -> {
            this.requeue(jobId);
            return BoxedUnit.UNIT;
        })).isFailure()) {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(54).append("Requeue failed for jobs that were submitted on node '").append(node).append("'").toString());
        }
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(37).append("Report status cleanup for node ").append(node).append(" ended").toString());
    }

    public void statusCleanup() {
        this.logger().debug((Function0 & Serializable)() -> "Report status cleanup started");
        if (Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.reportJobRepository.startedStaleJobIds(this.initializationTime()).foreach((Function1 & Serializable)jobId -> {
            this.failStaleJob(jobId);
            return BoxedUnit.UNIT;
        })).isFailure()) {
            this.logger().warn((Function0 & Serializable)() -> "Report status cleanup failed for stale jobs");
        }
        if (Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.reportJobRepository.submittedStaleJobIds(this.initializationTime()).foreach((Function1 & Serializable)jobId -> {
            this.requeue(jobId);
            return BoxedUnit.UNIT;
        })).isFailure()) {
            this.logger().warn((Function0 & Serializable)() -> "Requeue failed for previously submitted jobs");
        }
        this.logger().debug((Function0 & Serializable)() -> "Report status cleanup ended");
    }

    private void storageCleanup() {
        this.logger().debug((Function0 & Serializable)() -> "Report storage cleanup started");
        AuditReportSettings reportSettings = (AuditReportSettings)this.configurationRepository.read("Configuration/settings/AuditReportSettings");
        ReportJobFilters filter = new ReportJobFilters();
        ZonedDateTime retentionCutOffDate = LocalDateTime.now().minusDays(Predef$.MODULE$.Integer2int(reportSettings.getReportsRetentionPeriod())).atZone(ZoneId.systemDefault());
        filter.endTime_$eq(Interval.of((Instant)Instant.MIN, (Instant)retentionCutOffDate.toInstant()));
        filter.statuses_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ReportJobStatus.ABORTED.name(), ReportJobStatus.FAILED.name(), ReportJobStatus.COMPLETED.name()}))).asJava());
        Page<ReportJob> result = this.reportJobRepository.query(filter, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
        ListBuffer events = ListBuffer$.MODULE$.empty();
        result.get().forEach(reportJob -> {
            try {
                if ($this.globalReportStorage.cleanup((ReportJob)((Object)reportJob))) {
                    reportJob.status_$eq(ReportJobStatus.DELETED);
                    events.$plus$eq((Object)new ReportJobDeletedEvent($this.reportJobRepository.update((ReportJob)((Object)reportJob))));
                }
            }
            catch (Exception e) {
                this.logger().warn((Function0 & Serializable)() -> e.getMessage());
            }
        });
        events.foreach((Function1 & Serializable)x$1 -> {
            this.eventBus.publish(x$1);
            return BoxedUnit.UNIT;
        });
        this.logger().debug((Function0 & Serializable)() -> "Report storage cleanup finished");
    }

    private void failNodeJob(Integer jobId) {
        this.fail(jobId, new StringBuilder(89).append("Job '").append(jobId).append("' marked as '").append((Object)ReportJobStatus.FAILED).append("' because it was executing on a node that was removed from XLR cluster.").toString());
    }

    private void requeue(Integer jobId) {
        ReportJobInstance reportJobInstance = (ReportJobInstance)this.reportJobRepository.findByJobId(jobId).map((Function1 & Serializable)reportJob -> $this.reportJobInstanceFactory.create((ReportJob)((Object)reportJob))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(25).append("Job with id '").append(jobId).append("' not found.").toString(), new Object[0]);
        });
        reportJobInstance.enqueue();
        ReportJobDelegateActor.Enqueue x$1 = new ReportJobDelegateActor.Enqueue(jobId, reportJobInstance);
        ActorRef x$2 = this.reportJobDelegateActor().$bang$default$2((Object)x$1);
        this.reportJobDelegateActor().$bang((Object)x$1, x$2);
    }

    private void failStaleJob(Integer jobId) {
        this.fail(jobId, new StringBuilder(44).append("Job '").append(jobId).append("' is a stale report job that should be ").append((Object)ReportJobStatus.FAILED).toString());
    }

    private void fail(Integer jobId, String msg) {
        this.reportJobRepository.findByJobId(jobId).foreach((Function1 & Serializable)reportJob -> {
            ReportCleanerOperations.$anonfun$fail$1(this, msg, reportJob);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$fail$1(ReportCleanerOperations $this, String msg$1, ReportJob reportJob) {
        new Some((Object)$this.reportJobInstanceFactory.create(reportJob)).foreach((Function1 & Serializable)jobInstance -> {
            jobInstance.fail(new IllegalStateException(msg$1));
            return BoxedUnit.UNIT;
        });
    }

    public ReportCleanerOperations(ReportJobRepository reportJobRepository, ReportJobInstanceFactory reportJobInstanceFactory, ConfigurationRepository configurationRepository, GlobalReportStorage globalReportStorage, ReportJobDelegateActorHolder reportJobDelegateActorHolder, XLReleaseEventBus eventBus) {
        this.reportJobRepository = reportJobRepository;
        this.reportJobInstanceFactory = reportJobInstanceFactory;
        this.configurationRepository = configurationRepository;
        this.globalReportStorage = globalReportStorage;
        this.reportJobDelegateActorHolder = reportJobDelegateActorHolder;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        this.initializationTime = Date.from(Instant.now());
    }
}

