package com.xebialabs.xlrelease.reports.job.impl

import com.xebialabs.xlrelease.events.XLReleaseEventBus
import com.xebialabs.xlrelease.reports.job.api.ReportDefinition
import com.xebialabs.xlrelease.reports.job.domain.ReportJob
import com.xebialabs.xlrelease.reports.job.events.ReportJobSubmittedEvent
import com.xebialabs.xlrelease.reports.job.repository.ReportJobRepository
import org.springframework.context.ApplicationContext


trait ReportJobInstanceFactory {
  def create(reportJob: ReportJob): ReportJobInstance

  def submit(reportDefinition: ReportDefinition): ReportJobInstance
}

class DefaultReportJobInstanceFactory(applicationContext: ApplicationContext,
                                      reportingEngineConfiguration: ReportingEngineConfiguration,
                                      reportExecutorService: ReportExecutorService,
                                      reportJobRepository: ReportJobRepository,
                                      globalReportStorage: GlobalReportStorage,
                                      eventBus: XLReleaseEventBus)
  extends ReportJobInstanceFactory {

  override def create(reportJob: ReportJob): ReportJobInstance = {
    new ReportJobInstance(reportJob, applicationContext, reportingEngineConfiguration, reportExecutorService, reportJobRepository, globalReportStorage, eventBus)
  }

  override def submit(reportDefinition: ReportDefinition): ReportJobInstance = {
    val reportJob = ReportJob(reportDefinition)
    reportJob.setNode(reportingEngineConfiguration.node)
    reportJobRepository.create(reportJob)
    eventBus.publish(ReportJobSubmittedEvent(reportJob))
    this.create(reportJob)
  }
}
