package com.xebialabs.xlrelease.reports.job.spring

import com.xebialabs.deployit.security.PermissionEnforcer
import com.xebialabs.xlplatform.cluster.ClusterMode.{FULL, HOT_STANDBY, STANDALONE}
import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.events.XLReleaseEventBus
import com.xebialabs.xlrelease.reports.job.api.ReportingEngineService
import com.xebialabs.xlrelease.reports.job.impl._
import com.xebialabs.xlrelease.reports.job.impl.cleanup.ReportCleanerActorInitializer._
import com.xebialabs.xlrelease.reports.job.impl.cleanup.{ReportCleanerActorInitializer, ReportCleanerOperations}
import com.xebialabs.xlrelease.reports.job.repository.ReportJobRepository
import com.xebialabs.xlrelease.reports.job.repository.sql.SqlReportJobRepository
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.context.ApplicationContext
import org.springframework.context.annotation.{Bean, Configuration, Profile}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.scheduling.annotation.EnableAsync

@Configuration
@EnableAsync
class ReportingConfiguration {

  @Autowired
  var xlrConfig: XlrConfig = _

  @Autowired
  var applicationContext: ApplicationContext = _

  @Autowired
  var systemHolder: ActorSystemHolder = _

  @Autowired
  var sqlRepositoryAdapter: SqlRepositoryAdapter = _

  @Autowired
  @Qualifier("xlrRepositoryJdbcTemplate")
  var jdbcTemplate: JdbcTemplate = _

  @Autowired
  @Qualifier("xlrRepositorySqlDialect")
  var dialect: Dialect = _

  @Autowired
  var eventBus: XLReleaseEventBus = _

  @Autowired
  var configurationRepository: ConfigurationRepository = _

  @Autowired
  var permissionEnforcer: PermissionEnforcer = _

  @Bean
  def reportingEngineService: ReportingEngineService = {
    new DefaultReportingEngineService(applicationContext,
      reportJobInstanceFactory,
      reportJobRepository,
      reportStorage,
      permissionEnforcer,
      reportJobDelegateActorHolder,
      eventBus)
  }

  @Bean
  def reportStorage: GlobalReportStorage = {
    new GlobalReportStorage(xlrConfig.reporting.engine.location)
  }

  @Bean
  def reportJobRepository: ReportJobRepository = {
    new SqlReportJobRepository(jdbcTemplate, dialect, sqlRepositoryAdapter)
  }

  @Bean
  def reportJobInstanceFactory: ReportJobInstanceFactory = {
    new DefaultReportJobInstanceFactory(applicationContext, reportingEngineConfiguration, reportExecutorService, reportJobRepository, reportStorage, eventBus)
  }

  @Bean(destroyMethod = "shutdown")
  def reportExecutorService: ReportExecutorService = {
    new ReportExecutorService(xlrConfig)
  }

  @Bean
  def reportingEngineConfiguration: ReportingEngineConfiguration = {
    new ReportingEngineConfiguration(systemHolder)
  }

  @Bean
  @Profile(Array(FULL))
  def clusteredReportCleanerActorInitializer: ReportCleanerActorInitializer = {
    new ClusteredReportCleanerActorInitializer(systemHolder, xlrConfig, reportCleanerOperations, reportExecutorService)
  }

  @Bean
  def reportCleanerOperations: ReportCleanerOperations = {
    new ReportCleanerOperations(reportJobRepository, reportJobInstanceFactory, configurationRepository, reportStorage,
      reportJobDelegateActorHolder, eventBus)
  }

  @Bean
  def reportJobDelegateActorHolder: ReportJobDelegateActorHolder = {
    new ReportJobDelegateActorHolder(xlrConfig)
  }

  @Bean
  @Profile(Array(STANDALONE, HOT_STANDBY))
  def nonClusterReportDelegateJobActor: ReportJobDelegateActorInitializer = {
    new ReportJobDelegateActorInitializer.NonClusterReportJobDelegateActorInitializer(systemHolder, reportJobDelegateActorHolder, xlrConfig)
  }

  @Bean
  @Profile(Array(FULL))
  def clusteredReportDelegateJobActor: ReportJobDelegateActorInitializer = {
    new ReportJobDelegateActorInitializer.ClusteredReportJobDelegateActorInitializer(systemHolder, reportJobDelegateActorHolder, xlrConfig)
  }
}
