package com.xebialabs.xlrelease.reports.audit

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.reports.audit.MultiReleaseAuditReportComponent.EXCEL_CONTENT_TYPE
import com.xebialabs.xlrelease.reports.filters.ReportFilter
import com.xebialabs.xlrelease.reports.job.api.ReportJobRunContext
import com.xebialabs.xlrelease.reports.job.domain.BaseReportDefinition
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty
import org.springframework.beans.factory.annotation.Autowired

import java.io.File
import java.util.{List => JList}
import scala.beans.BeanProperty

@Metadata (description = "User Permissions Report", versioned = false)
class UserPermissionsReport extends BaseReportDefinition {

  @BeanProperty
  @Autowired
  @transient
  var reportComponent: UserPermissionsReportComponent = _

  @BeanProperty
  @XLProperty(asContainment = true)
  var filters: JList[ReportFilter] = _

  override def reportName: String = "Release User Permissions Report"

  @BeanProperty
  @XLProperty(hidden = true)
  val contentType: String = EXCEL_CONTENT_TYPE

  override def run(runContext: ReportJobRunContext): File = {
    reportComponent.generateReport(this, runContext)
  }

  override def preview(): Any = {
    reportComponent.preview(this)
  }
}
