package com.xebialabs.xlrelease.reports.excel;

import java.util.List;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;

import com.xebialabs.xlrelease.reports.dto.PhaseDuration;

public class TopLongestPhaseExport extends Export {
    private List<PhaseDuration> topLongestPhases;

    public static final int TITLE_COLUMN = 0;
    public static final int DURATION_COLUMN = 1;
    public static final int RELEASE_COLUMN = 2;

    private static final String TITLE_HEADER = "Phase";
    private static final String DURATION_HEADER = "Duration";
    private static final String RELEASE_HEADER = "Release";

    public TopLongestPhaseExport(List<PhaseDuration> topLongestPhases) {
        super();
        this.topLongestPhases = topLongestPhases;
    }

    @Override
    public void addContent() {
        for (PhaseDuration phaseDuration : topLongestPhases) {
            XSSFRow row = sheet.createRow(rowIndex++);

            CellUtil.createCell(row, TITLE_COLUMN, phaseDuration.getTitle());
            XSSFCell duration = row.createCell(DURATION_COLUMN);
            duration.setCellValue(phaseDuration.getDuration());
            CellUtil.createCell(row, RELEASE_COLUMN, phaseDuration.getRelease());
        }
    }

    @Override
    protected void setColumnsWidth() {
        sheet.setColumnWidth(TITLE_COLUMN, numberOfCharacter(30));
        sheet.setColumnWidth(DURATION_COLUMN, numberOfCharacter(15));
        sheet.setColumnWidth(RELEASE_COLUMN, numberOfCharacter(20));
    }

    @Override
    protected void addHeaderRow() {
        XSSFRow row = sheet.createRow(rowIndex++);
        CellUtil.createCell(row, TITLE_COLUMN, TITLE_HEADER);
        CellUtil.createCell(row, DURATION_COLUMN, DURATION_HEADER);
        CellUtil.createCell(row, RELEASE_COLUMN, RELEASE_HEADER);
        sheet.createRow(rowIndex++);
    }
}
