package com.xebialabs.xlrelease.reports.service

import com.xebialabs.xlrelease.reports.repository.TitleRepository
import com.xebialabs.xlrelease.repository.IdMatchers.DeliveryId
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class TitleService @Autowired()(titleRepository: TitleRepository) {

  def getTitleById(id: String): Option[String] = if (id != null) {
    id match {
      case DeliveryId(deliveryId) => titleRepository.getDeliveryTitleById(deliveryId)
      case _ => None
    }
  } else {
    None
  }

}