/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.audit;

import com.google.common.base.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.reports.audit.CommonFormat$;
import com.xebialabs.xlrelease.reports.domain.ReleaseData;
import com.xebialabs.xlrelease.reports.domain.ReleaseStartedBy;
import com.xebialabs.xlrelease.reports.domain.StartedByCreateReleaseTask;
import com.xebialabs.xlrelease.reports.domain.StartedByTrigger;
import com.xebialabs.xlrelease.reports.domain.StartedByUser;
import com.xebialabs.xlrelease.reports.domain.UserThatCreatedOrStartedRelease;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseTriggerRepository;
import com.xebialabs.xlrelease.service.ActivityLogsService;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public final class CreatedByDetailsHelper$ {
    public static CreatedByDetailsHelper$ MODULE$;

    static {
        new CreatedByDetailsHelper$();
    }

    public Option<ReleaseStartedBy> getCreationDetails(ReleaseRepository releaseRepository, ReleaseTriggerRepository triggerRepository, ActivityLogsService activityLogsService, UserInfoResolver userInfoResolver, ReleaseData releaseData) {
        Some some;
        Release release = releaseData.release();
        if (release.isCreatedFromTrigger()) {
            some = new Some((Object)this.tryToFetchTriggerInfo(triggerRepository, release));
        } else if (!Strings.isNullOrEmpty((String)release.getStartedFromTaskId())) {
            String masterReleaseId = Ids.releaseIdFrom((String)release.getStartedFromTaskId());
            some = new Some((Object)new StartedByCreateReleaseTask((Try<String>)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> releaseRepository.getTitle(masterReleaseId)), masterReleaseId));
        } else {
            None$ startedBy = release.isTemplate() || release.isPlanned() ? None$.MODULE$ : releaseData.startedByLogEntry().map((Function1 & Serializable & scala.Serializable)activityLogEntry -> MODULE$.getUserFromActivityLogEntry(userInfoResolver, (ActivityLogEntry)activityLogEntry));
            Option createdBy = releaseData.createdByLogEntry().map((Function1 & Serializable & scala.Serializable)activityLogEntry -> MODULE$.getUserFromActivityLogEntry(userInfoResolver, (ActivityLogEntry)activityLogEntry));
            some = new Some((Object)new StartedByUser((Option<UserThatCreatedOrStartedRelease>)startedBy, (Option<UserThatCreatedOrStartedRelease>)createdBy));
        }
        return some;
    }

    public StartedByTrigger tryToFetchTriggerInfo(ReleaseTriggerRepository triggerRepository, Release release) {
        StartedByTrigger startedByTrigger;
        Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getTags()).asScala()).find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.startsWith("Trigger"))).map((Function1 & Serializable & scala.Serializable)triggerTag -> new StartedByTrigger((Try<ReleaseTrigger>)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String triggerId = new StringBuilder(1).append(release.getOriginTemplateId()).append("/").append((String)triggerTag).toString();
            return triggerRepository.find(triggerId);
        }), (Option<String>)Option$.MODULE$.apply(triggerTag)));
        if (option instanceof Some) {
            StartedByTrigger startedByTrigger2;
            Some some = (Some)option;
            startedByTrigger = startedByTrigger2 = (StartedByTrigger)some.value();
        } else {
            startedByTrigger = new StartedByTrigger((Try<ReleaseTrigger>)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                throw new NotFoundException("Trigger tag is missing", new Object[0]);
            }), (Option<String>)Option$.MODULE$.empty());
        }
        return startedByTrigger;
    }

    public UserThatCreatedOrStartedRelease getUserFromActivityLogEntry(UserInfoResolver userInfoResolver, ActivityLogEntry activityLogEntry) {
        String username = CommonFormat$.MODULE$.getUsernameFromLogEntry(activityLogEntry);
        return new UserThatCreatedOrStartedRelease(username, (Option<String>)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)userInfoResolver.getFullNameOrUsernameOf(username))).toOption().flatten(Predef$.MODULE$.$conforms()));
    }

    private CreatedByDetailsHelper$() {
        MODULE$ = this;
    }
}

