/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.audit;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.reports.audit.CommonFormat;
import com.xebialabs.xlrelease.reports.audit.CommonFormat$TaskAgent$;
import com.xebialabs.xlrelease.reports.domain.MaybeData$;
import com.xebialabs.xlrelease.reports.domain.MaybeData$Implicits$;
import com.xebialabs.xlrelease.reports.domain.MaybeData$Implicits$EitherOps$;
import com.xebialabs.xlrelease.reports.domain.MaybeData$Implicits$MaybeOps$;
import com.xebialabs.xlrelease.reports.domain.ReleaseStartedBy;
import com.xebialabs.xlrelease.reports.domain.ReleaseTitleAndPath;
import com.xebialabs.xlrelease.reports.domain.StartedByCreateReleaseTask;
import com.xebialabs.xlrelease.reports.domain.StartedByTrigger;
import com.xebialabs.xlrelease.reports.domain.StartedByUser;
import com.xebialabs.xlrelease.reports.domain.UserThatCreatedOrStartedRelease;
import com.xebialabs.xlrelease.reports.domain.exceptions.ItemNotFoundException;
import com.xebialabs.xlrelease.reports.domain.exceptions.ItemNotFoundException$;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class CommonFormat$ {
    public static CommonFormat$ MODULE$;
    private final int MAXIMUM_CELL_LENGTH;
    private final String ACTIVITY_LOG_RECORD_NOT_FOUND_MESSAGE;
    private final String DATE_FORMAT;
    private final int DATE_WIDTH;

    static {
        new CommonFormat$();
    }

    public int MAXIMUM_CELL_LENGTH() {
        return this.MAXIMUM_CELL_LENGTH;
    }

    public String ACTIVITY_LOG_RECORD_NOT_FOUND_MESSAGE() {
        return this.ACTIVITY_LOG_RECORD_NOT_FOUND_MESSAGE;
    }

    public String DATE_FORMAT() {
        return this.DATE_FORMAT;
    }

    public int DATE_WIDTH() {
        return this.DATE_WIDTH;
    }

    public CommonFormat.TaskAgent taskAgent(String user, String team, String completedBy) {
        return CommonFormat$TaskAgent$.MODULE$.apply((Tuple2<Option<String>, Option<String>>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Option$.MODULE$.apply((Object)user)), (Object)Option$.MODULE$.apply((Object)team)), (Option<String>)Option$.MODULE$.apply((Object)completedBy));
    }

    public CommonFormat.TaskAgent taskAgent(String user, String team, String completedBy, Map<String, Try<Either<Tuple2<Throwable, String>, String>>> preResolvedProperties) {
        CommonFormat.TaskAgent qual$1 = this.taskAgent(user, team, completedBy);
        scala.collection.immutable.Map x$1 = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(preResolvedProperties).asScala()).toMap(Predef$.MODULE$.$conforms());
        Tuple2<Option<String>, Option<String>> x$2 = qual$1.copy$default$1();
        Option<String> x$3 = qual$1.copy$default$2();
        return qual$1.copy(x$2, x$3, (scala.collection.immutable.Map<String, Try<Either<Tuple2<Throwable, String>, String>>>)x$1);
    }

    public String getPlanItemTitle(Release release, PlanItem item) {
        String string;
        PlanItem planItem = item;
        if (planItem instanceof Task) {
            Task task = (Task)planItem;
            string = this.getTaskGroupTitle$1(task.getContainer(), task.getTitle());
        } else {
            string = item.getTitle();
        }
        String title = string;
        return VariableHelper$.MODULE$.replaceAll(title, release.getAllStringVariableValues(), new HashSet(), false);
    }

    public String getTaskType(Task task) {
        Type type;
        Task task2 = task;
        if (task2 instanceof CustomScriptTask) {
            CustomScriptTask customScriptTask = (CustomScriptTask)task2;
            type = customScriptTask.getPythonScript().getType();
        } else {
            type = task.getType();
        }
        Type taskType = type;
        String typeLabel = taskType.getDescriptor().getLabel();
        return Strings.isNullOrEmpty((String)typeLabel) ? task.getType().getName() : typeLabel;
    }

    public String getComments(Task task) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(task.getComments()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> new StringBuilder(2).append(entry.getAuthor()).append(": ").append(entry.getText()).toString(), Buffer$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public String getComment(Comment comment) {
        String author = comment.getAuthor() != null ? comment.getAuthor() : "SYSTEM";
        String commentText = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(14).append(author).append(" - ").append(comment.getCreationDate()).append("\n         |").append(comment.getText()).toString())).stripMargin();
        return commentText.substring(0, Math.min(commentText.length(), this.MAXIMUM_CELL_LENGTH()));
    }

    public String getIsDelayed(Task task) {
        return task.getDelayedCount() > 0 ? "Yes" : "No";
    }

    public Option<String> getTaskOwner(Release release, Task task) {
        return Option$.MODULE$.apply((Object)VariableHelper$.MODULE$.replaceAll(task.getOwner(), release.getAllStringVariableValues(), new HashSet(), false));
    }

    public Option<String> getTaskTeam(Task task) {
        return Option$.MODULE$.apply((Object)task.getTeam());
    }

    public Try<Either<Tuple2<Throwable, String>, String>> formatStartedByTrigger(StartedByTrigger startedByTrigger) {
        Try try_;
        Try<ReleaseTrigger> try_2 = startedByTrigger.trigger();
        if (try_2 instanceof Success) {
            Success success = (Success)try_2;
            ReleaseTrigger trigger = (ReleaseTrigger)success.value();
            try_ = MaybeData$.MODULE$.success(new StringBuilder(5).append(trigger.getTitle()).append(" (").append(new StringOps(Predef$.MODULE$.augmentString(trigger.getType().getPrefix())).capitalize()).append(": ").append(new StringOps(Predef$.MODULE$.augmentString(trigger.getType().getName())).capitalize()).append(")").toString());
        } else if (try_2 instanceof Failure) {
            Try try_3;
            Failure failure = (Failure)try_2;
            Throwable e = failure.exception();
            Option<String> option = startedByTrigger.triggerTag();
            if (option instanceof Some) {
                Some some = (Some)option;
                String triggerTag = (String)some.value();
                try_3 = MaybeData$.MODULE$.partial(e, new StringBuilder(10).append("Trigger [").append(triggerTag).append("]").toString());
            } else if (None$.MODULE$.equals(option)) {
                try_3 = MaybeData$.MODULE$.failure(e);
            } else {
                throw new MatchError(option);
            }
            try_ = try_3;
        } else {
            throw new MatchError(try_2);
        }
        return try_;
    }

    public String formatFolderPath(Seq<String> path) {
        return ((TraversableOnce)path.drop(1)).mkString(" / ");
    }

    public Try<Either<Tuple2<Throwable, String>, String>> formatStartedByMasterRelease(StartedByCreateReleaseTask startedByCreateReleaseTask) {
        return MaybeData$.MODULE$.recoverWith(startedByCreateReleaseTask.masterReleaseTitle(), (Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$1), (Object)new StringBuilder(2).append("[").append(startedByCreateReleaseTask.masterReleaseId()).append("]").toString()));
    }

    public Try<Either<Tuple2<Throwable, String>, String>> formatStartedByUser(Option<UserThatCreatedOrStartedRelease> startedBy) {
        return (Try)startedBy.map((Function1 & Serializable & scala.Serializable)u -> MaybeData$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (String)u.fullName().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CommonFormat$.$anonfun$formatStartedByUser$3(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> u.username()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> MaybeData$.MODULE$.failure(new ItemNotFoundException(MODULE$.ACTIVITY_LOG_RECORD_NOT_FOUND_MESSAGE(), ItemNotFoundException$.MODULE$.apply$default$2())));
    }

    public Try<Either<Tuple2<Throwable, String>, String>> formatStartedBy(Option<ReleaseStartedBy> startedBy) {
        return (Try)startedBy.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Try<Either<Tuple2<Throwable, String>, String>> try_;
            ReleaseStartedBy releaseStartedBy = x0$1;
            if (releaseStartedBy instanceof StartedByUser) {
                StartedByUser startedByUser = (StartedByUser)releaseStartedBy;
                try_ = MODULE$.formatStartedByUser(startedByUser.startedBy());
            } else if (releaseStartedBy instanceof StartedByTrigger) {
                StartedByTrigger startedByTrigger = (StartedByTrigger)releaseStartedBy;
                try_ = MODULE$.formatStartedByTrigger(startedByTrigger);
            } else if (releaseStartedBy instanceof StartedByCreateReleaseTask) {
                StartedByCreateReleaseTask startedByCreateReleaseTask = (StartedByCreateReleaseTask)releaseStartedBy;
                try_ = MODULE$.formatStartedByMasterRelease(startedByCreateReleaseTask);
            } else {
                throw new MatchError((Object)releaseStartedBy);
            }
            return try_;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> MaybeData$.MODULE$.success(""));
    }

    public Try<Either<Tuple2<Throwable, String>, String>> formatCreatedByUser(Option<UserThatCreatedOrStartedRelease> createdBy) {
        return (Try)createdBy.map((Function1 & Serializable & scala.Serializable)u -> MaybeData$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (String)u.fullName().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CommonFormat$.$anonfun$formatCreatedByUser$3(x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> u.username()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> MaybeData$.MODULE$.failure(new ItemNotFoundException(MODULE$.ACTIVITY_LOG_RECORD_NOT_FOUND_MESSAGE(), null)));
    }

    public String prettifyStatusString(String status) {
        return new StringOps(Predef$.MODULE$.augmentString(status)).capitalize().replace("_", " ");
    }

    public Try<Either<Tuple2<Throwable, String>, String>> getMaybeReleaseTitle(Try<Either<Tuple2<Throwable, Option<ReleaseTitleAndPath>>, Option<ReleaseTitleAndPath>>> templateInfo) {
        return MaybeData$Implicits$MaybeOps$.MODULE$.mapValue$extension(MaybeData$Implicits$.MODULE$.MaybeOps(templateInfo), (Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.title()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public Try<Either<Tuple2<Throwable, String>, String>> getMaybeReleasePath(Try<Either<Tuple2<Throwable, Option<ReleaseTitleAndPath>>, Option<ReleaseTitleAndPath>>> templateInfo) {
        return templateInfo.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> (Try)((Option)MaybeData$Implicits$EitherOps$.MODULE$.getValue$extension(MaybeData$Implicits$.MODULE$.EitherOps(x$6))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.path()).getOrElse((Function0 & Serializable & scala.Serializable)() -> MaybeData$.MODULE$.success("")));
    }

    private final String getTaskGroupTitle$1(TaskContainer container, String currentTitle) {
        TaskContainer taskContainer;
        while ((taskContainer = container) instanceof TaskGroup) {
            TaskGroup taskGroup = (TaskGroup)taskContainer;
            currentTitle = new StringBuilder(3).append(taskGroup.getTitle()).append(" / ").append(currentTitle).toString();
            container = taskGroup.getContainer();
        }
        String string = currentTitle;
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$formatStartedByUser$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$formatCreatedByUser$3(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    private CommonFormat$() {
        MODULE$ = this;
        this.MAXIMUM_CELL_LENGTH = Short.MAX_VALUE;
        this.ACTIVITY_LOG_RECORD_NOT_FOUND_MESSAGE = "Activity log record not found";
        this.DATE_FORMAT = "mmmm d, yyyy hh:mm AM/PM";
        this.DATE_WIDTH = 30;
    }
}

