/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.dto;

import com.xebialabs.xlrelease.reports.dto.AverageByMonthComputer;
import com.xebialabs.xlrelease.reports.dto.ReleaseAutomationData;
import com.xebialabs.xlrelease.reports.dto.ReleaseEfficiency;
import com.xebialabs.xlrelease.reports.dto.ReleasesAutomation;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ReleaseAutomationComputer {
    private List<ReleaseAutomationData> releasesAutomationData;
    private ReleasesAutomation releasesAutomation = new ReleasesAutomation();

    public ReleaseAutomationComputer(List<ReleaseAutomationData> releasesAutomationData, ReleaseEfficiency releaseEfficiency) {
        this.releasesAutomation.setReleaseEfficiency(releaseEfficiency);
        this.releasesAutomationData = releasesAutomationData;
    }

    public ReleasesAutomation get() {
        if (this.releasesAutomationData.size() > 0) {
            Collections.sort(this.releasesAutomationData, new Comparator<ReleaseAutomationData>(){

                @Override
                public int compare(ReleaseAutomationData o1, ReleaseAutomationData o2) {
                    return o1.getEndDate().compareTo((ReadableInstant)o2.getEndDate());
                }
            });
            DateTime startDate = this.releasesAutomationData.get(0).getEndDate();
            AverageByMonthComputer averageAutomationComputer = new AverageByMonthComputer(startDate);
            for (ReleaseAutomationData releaseAutomationData : this.releasesAutomationData) {
                float automationPercentage = this.computePercentage(releaseAutomationData.getNumberOfAutomatedTasks(), releaseAutomationData.getNumberOfTasks());
                averageAutomationComputer.add(releaseAutomationData.getEndDate(), automationPercentage);
            }
            DateTime endDate = this.releasesAutomationData.get(this.releasesAutomationData.size() - 1).getEndDate();
            this.releasesAutomation.setAverageAutomationPercentage(averageAutomationComputer.completeSerie(endDate));
        }
        return this.releasesAutomation;
    }

    private float computePercentage(float number, float total) {
        return number / total * 100.0f;
    }
}

