/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.excel;

import com.xebialabs.xlrelease.reports.domain.ReportError;
import com.xebialabs.xlrelease.reports.excel.ErrorSheet$;
import com.xebialabs.xlrelease.reports.excel.ExcelHeaderColumn;
import com.xebialabs.xlrelease.reports.excel.ExcelSheetWriter;
import com.xebialabs.xlrelease.reports.excel.ExcelStyles;
import java.awt.Color;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import scala.Function1;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001M;Q\u0001E\t\t\u0002q1QAH\t\t\u0002}AQAJ\u0001\u0005\u0002\u001dBq\u0001K\u0001C\u0002\u0013\u0005\u0011\u0006\u0003\u0004.\u0003\u0001\u0006IA\u000b\u0005\b]\u0005\u0011\r\u0011\"\u0001*\u0011\u0019y\u0013\u0001)A\u0005U!9\u0001'\u0001b\u0001\n\u0003I\u0003BB\u0019\u0002A\u0003%!F\u0002\u0003\u001f#\u0001\u0011\u0004\u0002C\u001a\n\u0005\u000b\u0007I\u0011\u0001\u001b\t\u0011aJ!\u0011!Q\u0001\nUBQAJ\u0005\u0005\u0002eBQ\u0001P\u0005\u0005\u0002uBQAR\u0005\u0005\n\u001dCQ!S\u0005\u0005\u0012)\u000b!\"\u0012:s_J\u001c\u0006.Z3u\u0015\t\u00112#A\u0003fq\u000e,GN\u0003\u0002\u0015+\u00059!/\u001a9peR\u001c(B\u0001\f\u0018\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u00193\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00025\u0005\u00191m\\7\u0004\u0001A\u0011Q$A\u0007\u0002#\tQQI\u001d:peNCW-\u001a;\u0014\u0005\u0005\u0001\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00029\u0005a1\u000bS#F)~\u001bu\nT+N\u001dV\t!\u0006\u0005\u0002\u001eW%\u0011A&\u0005\u0002\u0012\u000bb\u001cW\r\u001c%fC\u0012,'oQ8mk6t\u0017!D*I\u000b\u0016#vlQ(M+6s\u0005%A\u0006D\u000b2culQ(M+6s\u0015\u0001D\"F\u00192{6i\u0014'V\u001b:\u0003\u0013\u0001D#S%>\u0013vlQ(M+6s\u0015!D#S%>\u0013vlQ(M+6s\u0005e\u0005\u0002\nA\u0005Y1\u000f[3fi^\u0013\u0018\u000e^3s+\u0005)\u0004CA\u000f7\u0013\t9\u0014C\u0001\tFq\u000e,Gn\u00155fKR<&/\u001b;fe\u0006a1\u000f[3fi^\u0013\u0018\u000e^3sAQ\u0011!h\u000f\t\u0003;%AQa\r\u0007A\u0002U\n!\"\u00193e\u0007>tG/\u001a8u)\tq\u0014\t\u0005\u0002\"\u007f%\u0011\u0001I\t\u0002\u0005+:LG\u000fC\u0003C\u001b\u0001\u00071)\u0001\u0004tifdWm\u001d\t\u0003;\u0011K!!R\t\u0003\u0017\u0015C8-\u001a7TifdWm]\u0001\nC\u0012$\u0007*Z1eKJ$\"!\u000e%\t\u000b\ts\u0001\u0019A\"\u0002\u0011\u0005$G-\u0012:s_J$\"AP&\t\u000b1{\u0001\u0019A'\u0002\u0017I,\u0007o\u001c:u\u000bJ\u0014xN\u001d\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!N\ta\u0001Z8nC&t\u0017B\u0001*P\u0005-\u0011V\r]8si\u0016\u0013(o\u001c:")
public class ErrorSheet {
    private final ExcelSheetWriter sheetWriter;

    public static ExcelHeaderColumn ERROR_COLUMN() {
        return ErrorSheet$.MODULE$.ERROR_COLUMN();
    }

    public static ExcelHeaderColumn CELL_COLUMN() {
        return ErrorSheet$.MODULE$.CELL_COLUMN();
    }

    public static ExcelHeaderColumn SHEET_COLUMN() {
        return ErrorSheet$.MODULE$.SHEET_COLUMN();
    }

    public ExcelSheetWriter sheetWriter() {
        return this.sheetWriter;
    }

    public void addContent(ExcelStyles styles) {
        this.addHeader(styles);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.sheetWriter().getReportWorkbook().getErrors()).asScala()).foreach((Function1 & Serializable & scala.Serializable)e -> {
            this.addError(e);
            return BoxedUnit.UNIT;
        });
    }

    private ExcelSheetWriter addHeader(ExcelStyles styles) {
        return this.sheetWriter().newRow().addCell("Note, that links may point to wrong cell if you make any changes", styles.addBackgroundColor(styles.bold(), Color.YELLOW)).mergeCells(new CellRangeAddress(this.sheetWriter().rowIndex - 1, this.sheetWriter().rowIndex - 1, this.sheetWriter().columnIndex - 1, this.sheetWriter().columnIndex)).newRow().addCell("(for example change order of rows in tables by using sort feature)", styles.addBackgroundColor(styles.bold(), Color.YELLOW)).mergeCells(new CellRangeAddress(this.sheetWriter().rowIndex - 1, this.sheetWriter().rowIndex - 1, this.sheetWriter().columnIndex - 1, this.sheetWriter().columnIndex)).newRow().newRow().addHeaderCell(ErrorSheet$.MODULE$.SHEET_COLUMN(), styles.whiteOnGreen()).addHeaderCell(ErrorSheet$.MODULE$.CELL_COLUMN(), styles.whiteOnGreen()).addHeaderCell(ErrorSheet$.MODULE$.ERROR_COLUMN(), styles.whiteOnGreen());
    }

    public void addError(ReportError reportError) {
        block1: {
            this.sheetWriter().newRow();
            String humanReadableAddressOfCellWithData = new StringBuilder(0).append(CellReference.convertNumToColString((int)reportError.col())).append(reportError.row()).toString();
            String addressOfCellWithData = new StringBuilder(3).append("'").append(reportError.sheet().getSheetName()).append("'!").append(humanReadableAddressOfCellWithData).toString();
            XSSFHyperlink linkFromErrorSheetToReportSheetForSheetNameCell = this.sheetWriter().getWorkbook().getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
            linkFromErrorSheetToReportSheetForSheetNameCell.setAddress(addressOfCellWithData);
            XSSFHyperlink linkFromErrorSheetToReportSheetForAddressCell = this.sheetWriter().getWorkbook().getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
            linkFromErrorSheetToReportSheetForAddressCell.setAddress(addressOfCellWithData);
            this.sheetWriter().addCell(reportError.sheet().getSheetName());
            this.sheetWriter().getSheet().getRow(this.sheetWriter().rowIndex - 1).getCell(this.sheetWriter().columnIndex - 1).setHyperlink((Hyperlink)linkFromErrorSheetToReportSheetForSheetNameCell);
            this.sheetWriter().addCell(humanReadableAddressOfCellWithData);
            this.sheetWriter().getSheet().getRow(this.sheetWriter().rowIndex - 1).getCell(this.sheetWriter().columnIndex - 1).setHyperlink((Hyperlink)linkFromErrorSheetToReportSheetForAddressCell);
            this.sheetWriter().addCell(reportError.throwable().getMessage());
            String addressOfCellWithErrorDescription = new StringBuilder(3).append("'").append(this.sheetWriter().getSheet().getSheetName()).append("'!").append(CellReference.convertNumToColString((int)(this.sheetWriter().columnIndex - 1))).append(this.sheetWriter().rowIndex).toString();
            XSSFHyperlink linkFromReportSheetToErrorSheet = this.sheetWriter().getWorkbook().getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
            linkFromReportSheetToErrorSheet.setAddress(addressOfCellWithErrorDescription);
            XSSFCell targetCell = reportError.sheet().getRow(reportError.row() - 1).getCell(reportError.col());
            targetCell.setHyperlink((Hyperlink)linkFromReportSheetToErrorSheet);
            CellType cellType = targetCell.getCellTypeEnum();
            CellType cellType2 = CellType.STRING;
            if (cellType != null ? !cellType.equals(cellType2) : cellType2 != null) break block1;
            if (targetCell.getStringCellValue() == null || targetCell.getStringCellValue().isEmpty()) {
                targetCell.setCellValue(StringUtils.repeat((String)"\u00a0", (int)255));
            }
        }
    }

    public ErrorSheet(ExcelSheetWriter sheetWriter) {
        this.sheetWriter = sheetWriter;
    }
}

