/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.domain.riskassessors;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.riskassessors.PlanItemDueDateRiskAssessor;
import java.util.ArrayList;

@Metadata(label="ReleaseDueDateAssessor", versioned=false)
public class ReleaseDueDateRiskAssessor
extends PlanItemDueDateRiskAssessor {
    private static final String RELEASE_OVERDUE_HEADLINE = "Release is overdue";

    @Override
    public RiskAssessment execute(Release release, RiskProfile riskProfile) {
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());
        ArrayList<String> messages = new ArrayList<String>();
        if (release.isOverdue()) {
            assessment.setScore(riskProfile.getValueFor(this.getType()));
            assessment.setHeadline(RELEASE_OVERDUE_HEADLINE);
            messages.add(this.formatMessage((PlanItem)release).trim());
        } else {
            assessment.setScore(0);
            assessment.setHeadline("Release is on track");
        }
        assessment.setMessages(messages);
        return assessment;
    }
}

