package com.xebialabs.xlrelease.risk.api.internal

import com.xebialabs.xlrelease.risk.service.RiskProfileService
import com.xebialabs.xlrelease.risk.views.ReleaseListView
import com.xebialabs.xlrelease.security.PermissionChecker
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

import java.util.{List => JList}
import javax.ws.rs.{GET, Path, PathParam}
import scala.jdk.CollectionConverters._

@Controller
@Path("/risks")
class RiskResource @Autowired()(permissions: PermissionChecker,
                                riskProfileService: RiskProfileService) {

  @GET
  @Path("profiles/{riskProfileId:.*RiskProfile[^/-]*}/references")
  def getReferences(@PathParam("riskProfileId") riskProfileId: String): JList[ReleaseListView] = {
    riskProfileService.getReferences(riskProfileId).asScala.map(data => {
      val view = new ReleaseListView
      view.id = data.id
      view.title = data.title
      view
    }).asJava
  }
}
