package com.xebialabs.xlrelease.risk.initialize

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.risk.configuration.RiskGlobalThresholds
import com.xebialabs.xlrelease.risk.configuration.RiskGlobalThresholds.RISK_GLOBAL_THRESHOLD_SETTINGS_ID
import com.xebialabs.xlrelease.service.ConfigurationService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class RiskGlobalThresholdsInitializer @Autowired()(configurationService: ConfigurationService)
  extends BaseInitializingUpgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "7.5.0#1")

  override def doUpgrade(): Boolean = {
    logger.info("Creating default risk global thresholds")
    val globalThresholds = new RiskGlobalThresholds
    globalThresholds.setId(RISK_GLOBAL_THRESHOLD_SETTINGS_ID)
    configurationService.createOrUpdate(globalThresholds)
    logger.debug("Finished creating default risk global thresholds")
    true
  }
}
