package com.xebialabs.xlrelease.risk.spring.config;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.MetricsConfiguration;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;

@Configuration
@EnableAsync
public class RiskConfiguration {

    private static final String RISK_CALCULATION = "risk-calculation";
    private static final String RISK_CALCULATION_BATCH = "risk-calculation-batch";
    public static final String RISK_CALCULATION_EXECUTOR = "riskCalculationExecutor";

    @Bean(name = RISK_CALCULATION_EXECUTOR)
    public RestartableExecutorService riskCalculationExecutor(XlrConfig xlrConfig, MeterRegistry meterRegistry) {
        return new RestartableExecutorService(RISK_CALCULATION, () -> {
            ExecutorService executor = Executors.newFixedThreadPool(4, new PrefixedThreadFactory(RISK_CALCULATION, true));
            if (xlrConfig.metrics().enabled()) {
                return ExecutorServiceMetrics.monitor(meterRegistry, executor, RISK_CALCULATION, MetricsConfiguration.TAG_EXECUTOR());
            }
            return executor;
        });
    }

    @Bean
    public Executor riskCalculationBatchExecutor(XlrConfig xlrConfig, MeterRegistry meterRegistry) {
        ExecutorService executor = Executors.newFixedThreadPool(2, new PrefixedThreadFactory(RISK_CALCULATION_BATCH, true));
        if (xlrConfig.metrics().enabled()) {
            ExecutorServiceMetrics.monitor(meterRegistry, executor, RISK_CALCULATION_BATCH, MetricsConfiguration.TAG_EXECUTOR());
        }
        return executor;
    }
}
