package com.xebialabs.xlrelease.risk.views.converters;

import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.risk.domain.Risk;
import com.xebialabs.xlrelease.risk.views.RiskView;
import com.xebialabs.xlrelease.views.converters.ReleaseExtensionViewConverter;

@Component
public class RiskViewConverter implements ReleaseExtensionViewConverter<Risk, RiskView> {

    @Override
    public RiskView toView(final Risk releaseExtension) {
        RiskView view = new RiskView();
        view.setId(releaseExtension.getId());
        view.setScore(releaseExtension.getScore());
        return view;
    }

    @Override
    public Class<? extends Risk> getReleaseExtensionClass() {
        return Risk.class;
    }

}
