package com.xebialabs.xlrelease.risk.initialize

import com.xebialabs.deployit.plugin.api.reflect.{DescriptorRegistry, Type}
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.risk.domain.RiskProfile
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor
import com.xebialabs.xlrelease.service.ConfigurationService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.{BaseInitializingUpgrade, ClassNameToString}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class DefaultRiskProfileInitializer @Autowired()(configurationService: ConfigurationService)
  extends BaseInitializingUpgrade with Logging with ClassNameToString {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "7.5.0#2")

  override def doUpgrade(): Boolean = {
    logger.info("Creating default risk profile")
    val defaultRiskProfile = new RiskProfile("Default risk profile")
    defaultRiskProfile.setId(RiskProfile.DEFAULT_RISK_PROFILE_ID)
    defaultRiskProfile.setDefaultProfile(true)

    DescriptorRegistry.getSubtypes(Type.valueOf(classOf[RiskAssessor])).asScala
        .filter((`type`: Type) => !`type`.getDescriptor.isVirtual)
        .foreach(t => defaultRiskProfile.setValueFor(t, t.getDescriptor.getPropertyDescriptor("score").getDefaultValue.asInstanceOf[Int]))

    configurationService.createOrUpdate(defaultRiskProfile)
    logger.debug("Finished creating default risk profile")
    true
  }

}
