package com.xebialabs.xlrelease.spring.config

import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence
import com.xebialabs.xlrelease.risk.domain.Risk
import com.xebialabs.xlrelease.risk.repository.RiskRepository
import com.xebialabs.xlrelease.risk.repository.sql.persistence.RiskPersistence
import com.xebialabs.xlrelease.service.ReleaseService
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class SqlRiskConfiguration {

  @Bean
  def riskRepository(riskPersistence: RiskPersistence,
                     releasePersistence: ReleasePersistence,
                     releaseService: ReleaseService,
                     releaseExtensionsRepository: ReleaseExtensionsRepository): RiskRepository = {
    val repository: RiskRepository = new RiskRepository(riskPersistence, releasePersistence, releaseService)
    releaseExtensionsRepository.register[Risk, RiskRepository](repository)
    repository
  }

}
