package com.xebialabs.xlrelease.risk.api.v1.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.xlrelease.api.v1.RiskAssessmentApi;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.repository.RiskRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;

@Controller
public class RiskAssessmentApiImpl implements RiskAssessmentApi {

    private PermissionChecker permissionChecker;
    private RiskRepository riskRepository;

    @Autowired
    public RiskAssessmentApiImpl(final PermissionChecker permissionChecker, final RiskRepository riskRepository) {
        this.permissionChecker = permissionChecker;
        this.riskRepository = riskRepository;
    }

    @Override
    public RiskAssessment getAssessment(String riskAssessmentId) {
        permissionChecker.checkView(Ids.releaseIdFrom(riskAssessmentId));
        return riskRepository.findRiskAssessmentById(riskAssessmentId);
    }
}
