package com.xebialabs.xlrelease.risk.export;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.export.TemplateImportProcessor;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.service.RiskProfileService;

import static com.xebialabs.xlrelease.risk.domain.RiskProfile.DEFAULT_RISK_PROFILE_ID;
import static com.xebialabs.xlrelease.risk.domain.RiskProfile.RISK_PROFILE;

@Service
public class RiskProfileImportProcessor implements TemplateImportProcessor {

    private RiskProfileService riskProfileService;

    @Autowired
    public RiskProfileImportProcessor(RiskProfileService riskProfileService) {
        this.riskProfileService = riskProfileService;
    }

    @Override
    public List<String> process(final Release template, final String destinationId) {
        List<String> warnings = new ArrayList<>();
        if (!template.hasProperty(RISK_PROFILE)) return warnings;

        RiskProfile riskProfile = template.getProperty(RISK_PROFILE);
        if (null == riskProfile) {
            return warnings;
        }

        if (!riskProfileService.exists(riskProfile.getId())) {
            warnings.add("Associated Risk profile does not exist: Used \"Default risk profile\"");
            template.setProperty(RISK_PROFILE, riskProfileService.findById(DEFAULT_RISK_PROFILE_ID));
        }

        return warnings;
    }

}
