package com.xebialabs.xlrelease.risk.views.converters;

import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.risk.domain.progress.ReleaseProgress;
import com.xebialabs.xlrelease.risk.views.ReleaseProgressView;
import com.xebialabs.xlrelease.views.converters.ReleaseExtensionViewConverter;

@Component
public class ReleaseProgressViewConverter implements ReleaseExtensionViewConverter<ReleaseProgress, ReleaseProgressView> {

    @Override
    public ReleaseProgressView toView(final ReleaseProgress releaseProgress) {
        ReleaseProgressView view = new ReleaseProgressView();
        view.setId(releaseProgress.getId());
        view.setTotalTasks(releaseProgress.getTotalTasks());
        view.setTotalRemainingTasks(releaseProgress.getTotalRemainingTasks());
        view.setPhases(releaseProgress.getPhasesProgress());
        return view;
    }

    @Override
    public Class<? extends ReleaseProgress> getReleaseExtensionClass() {
        return ReleaseProgress.class;
    }
}
