/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.SynchronizedSubscribe;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskProfileUpdated;
import com.xebialabs.xlrelease.risk.service.RiskService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005Q4A\u0001C\u0005\u0001)!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0004\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u000b\u0005\u0003A\u0011\u0001\"\t\u000b!\u0003A\u0011A%\t\u000bu\u0003A\u0011\u00020\u0003!IK7o[#wK:$\b*\u00198eY\u0016\u0014(B\u0001\u0006\f\u0003\u001d\u0019XM\u001d<jG\u0016T!\u0001D\u0007\u0002\tIL7o\u001b\u0006\u0003\u001d=\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005A\t\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005\u0011\u0012aA2p[\u000e\u00011c\u0001\u0001\u00167A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\u0004\"\u0001H\u0011\u000e\u0003uQ!AH\u0010\u0002\u000bMdg\r\u000e6\u000b\u0003\u0001\n\u0001b\u001a:jujdW\rZ\u0005\u0003Eu\u0011q\u0001T8hO&tw-A\u0005yYJ\u001cuN\u001c4jOB\u0011Q\u0005K\u0007\u0002M)\u0011q%D\u0001\u0007G>tg-[4\n\u0005%2#!\u0003-me\u000e{gNZ5h\u0003]\u0019wN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002-_5\tQF\u0003\u0002/\u001b\u0005Q!/\u001a9pg&$xN]=\n\u0005Aj#aF\"p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z\u0003-\u0011\u0018n]6TKJ4\u0018nY3\u0011\u0005M\"T\"A\u0005\n\u0005UJ!a\u0003*jg.\u001cVM\u001d<jG\u0016\fAD]5tW\u000e\u000bGnY;mCRLwN\u001c\"bi\u000eDW\t_3dkR|'\u000f\u0005\u00029\u007f5\t\u0011H\u0003\u0002;w\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005qj\u0014\u0001B;uS2T\u0011AP\u0001\u0005U\u00064\u0018-\u0003\u0002As\tAQ\t_3dkR|'/\u0001\u0004=S:LGO\u0010\u000b\u0006\u0007\u0012+ei\u0012\t\u0003g\u0001AQaI\u0003A\u0002\u0011BQAK\u0003A\u0002-BQ!M\u0003A\u0002IBQAN\u0003A\u0002]\nq\u0003[1oI2,'+[:l!J|g-\u001b7f+B$\u0017\r^3\u0015\u0005)k\u0005C\u0001\fL\u0013\tauC\u0001\u0003V]&$\b\"\u0002(\u0007\u0001\u0004y\u0015!B3wK:$\bC\u0001)V\u001b\u0005\t&B\u0001*T\u0003\u0019)g/\u001a8ug*\u0011AkC\u0001\u0007I>l\u0017-\u001b8\n\u0005Y\u000b&A\u0005*jg.\u0004&o\u001c4jY\u0016,\u0006\u000fZ1uK\u0012D#A\u0002-\u0011\u0005e[V\"\u0001.\u000b\u0005Ik\u0011B\u0001/[\u0005U\u0019\u0016P\\2ie>t\u0017N_3e'V\u00147o\u0019:jE\u0016\fQD];o\u0007\u0006d7-\u001e7bi&|gn\u001d$peJK7o\u001b)s_\u001aLG.\u001a\u000b\u0003\u0015~CQ\u0001Y\u0004A\u0002\u0005\f1B]5tWB\u0013xNZ5mKB\u0011!mY\u0007\u0002'&\u0011Am\u0015\u0002\f%&\u001c8\u000e\u0015:pM&dW\r\u000b\u0002\u0001MB\u0011qM\\\u0007\u0002Q*\u0011\u0011N[\u0001\u000bgR,'/Z8usB,'BA6m\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A7\u0002\u0007=\u0014x-\u0003\u0002pQ\n91+\u001a:wS\u000e,\u0007F\u0001\u0001r!\tI&/\u0003\u0002t5\niQI^3oi2K7\u000f^3oKJ\u0004")
public class RiskEventHandler
implements Logging {
    private final XlrConfig xlrConfig;
    private final ConfigurationRepository configurationRepository;
    private final RiskService riskService;
    private final Executor riskCalculationBatchExecutor;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskEventHandler riskEventHandler = this;
        synchronized (riskEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @SynchronizedSubscribe
    public void handleRiskProfileUpdate(RiskProfileUpdated event) {
        if (this.xlrConfig.isRiskCalculationEnabled()) {
            RiskProfile riskProfile = event.riskProfile();
            this.riskCalculationBatchExecutor.execute(() -> this.runCalculationsForRiskProfile(riskProfile));
            return;
        }
    }

    private void runCalculationsForRiskProfile(RiskProfile riskProfile) {
        this.logger().debug((Function0 & Serializable)() -> "Running risk calculations after Risk profile " + riskProfile.getId() + " update");
        this.configurationRepository.getReferenceReleases(riskProfile.getId()).forEach(data -> $this.riskService.calculateRiskAndUpdateRelease(data.id()));
        this.logger().debug((Function0 & Serializable)() -> "Finished running risk calculations after Risk profile " + riskProfile.getId() + " update");
    }

    public RiskEventHandler(XlrConfig xlrConfig, ConfigurationRepository configurationRepository, RiskService riskService, Executor riskCalculationBatchExecutor) {
        this.xlrConfig = xlrConfig;
        this.configurationRepository = configurationRepository;
        this.riskService = riskService;
        this.riskCalculationBatchExecutor = riskCalculationBatchExecutor;
        Logging.$init$((Logging)this);
    }
}

