/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.spring.config;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.scheduler.RestartableExecutorService;
import com.xebialabs.xlrelease.scheduler.XlrExecutors;
import com.xebialabs.xlrelease.service.FeatureService;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
public class RiskConfiguration
implements FeatureService {
    private static final String RISK_CALCULATION = "risk-calculation";
    private static final String RISK_CALCULATION_BATCH = "risk-calculation-batch";
    public static final String RISK_CALCULATION_EXECUTOR = "riskCalculationExecutor";
    private final XlrConfig xlrConfig;
    private volatile boolean enabled = true;
    private final MeterRegistry meterRegistry;

    public RiskConfiguration(MeterRegistry meterRegistry, XlrConfig xlrConfig) {
        this.meterRegistry = meterRegistry;
        this.xlrConfig = xlrConfig;
    }

    @Bean(name={"riskCalculationExecutor"})
    public RestartableExecutorService riskCalculationExecutor() {
        int maxThreads = this.xlrConfig.executors().riskCalculation().maxThreadsCount();
        int shutdownTimeout = this.xlrConfig.executors().riskCalculation().shutdownTimeout();
        return XlrExecutors.newFixedThreadPool((String)RISK_CALCULATION, (int)maxThreads, (MeterRegistry)this.meterRegistry, (long)shutdownTimeout);
    }

    @Bean
    public RestartableExecutorService riskCalculationBatchExecutor() {
        int maxThreads = this.xlrConfig.executors().riskCalculationBatch().maxThreadsCount();
        int shutdownTimeout = this.xlrConfig.executors().riskCalculationBatch().shutdownTimeout();
        return XlrExecutors.newFixedThreadPool((String)RISK_CALCULATION_BATCH, (int)maxThreads, (MeterRegistry)this.meterRegistry, (long)shutdownTimeout);
    }

    public String serviceName() {
        return "risk execution service";
    }

    public void start() {
        if (!this.enabled) {
            this.riskCalculationExecutor().start();
            this.riskCalculationBatchExecutor().start();
        }
        this.enabled = true;
    }

    public void stop() {
        if (this.enabled) {
            this.riskCalculationExecutor().stop();
            this.riskCalculationBatchExecutor().stop();
        }
        this.enabled = false;
    }

    public boolean isRunning() {
        return this.enabled;
    }
}

