/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.domain;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.risk.repository.RiskIds;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@Metadata(description="A Risk Profile", root=Metadata.ConfigurationItemRoot.CONFIGURATION, versioned=false)
@PublicApiRef
@ShowOnlyPublicApiMembers
public class RiskProfile
extends BaseConfiguration {
    public static final String DEFAULT_RISK_PROFILE_ID = RiskIds.RISK_PROFILE_CONFIGURATION_ROOT() + "/RiskProfileDefault";
    @Property(description="The name of risk profile.")
    private String title;
    @Property(description="Is this default risk profile.", defaultValue="false")
    private boolean defaultProfile;
    @Property
    private Map<String, String> riskProfileAssessors = new HashMap<String, String>();

    public RiskProfile() {
    }

    public RiskProfile(String title) {
        this.title = title;
    }

    public int getValueFor(String riskProfileAssessorKey, int defaultValue) {
        if (!this.riskProfileAssessors.containsKey(riskProfileAssessorKey)) {
            return defaultValue;
        }
        return Integer.parseInt(this.riskProfileAssessors.get(riskProfileAssessorKey));
    }

    public int getValueFor(Type riskProfileAssessorType) {
        String key = riskProfileAssessorType.toString();
        Integer defaultValue = (Integer)riskProfileAssessorType.getDescriptor().getPropertyDescriptor("score").getDefaultValue();
        return this.getValueFor(key, defaultValue);
    }

    public void setValueFor(Type riskProfileAssessorType, int value) {
        this.riskProfileAssessors.put(riskProfileAssessorType.toString(), "" + value);
    }

    @PublicApiMember
    public String getTitle() {
        return this.title;
    }

    @PublicApiMember
    public void setTitle(String title) {
        this.title = title;
    }

    public boolean hasRiskAssessorEnabled(Type type) {
        return this.isDefaultProfile() || this.riskProfileAssessors.containsKey(type.toString());
    }

    @PublicApiMember
    public boolean isDefaultProfile() {
        return DEFAULT_RISK_PROFILE_ID.equalsIgnoreCase(this.id);
    }

    @PublicApiMember
    public Map<String, String> getRiskProfileAssessors() {
        return this.riskProfileAssessors;
    }

    @PublicApiMember
    public void setRiskProfileAssessors(Map<String, String> riskProfileAssessors) {
        this.riskProfileAssessors = riskProfileAssessors;
    }

    public static String generateRiskProfileId(String name) {
        return Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/riskProfiles/" + name;
    }

    public static String generateRiskProfileId() {
        return RiskProfile.generateRiskProfileId(UUID.randomUUID().toString());
    }

    public void setDefaultProfile(boolean defaultProfile) {
        this.defaultProfile = defaultProfile;
    }
}

