package com.xebialabs.xlrelease.scm.connector;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlrelease.domain.configuration.HttpConnection;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

// insourced from xlr-git-plugin
@Metadata()
@PublicApiRef
@ShowOnlyPublicApiMembers
public class Repository extends HttpConnection {
    // TODO write an upgrader to get rid of git plugin legacy


    @Property(required = false, description = "Username that is associated with the Git commits", category = "Configuration")
    String committerUsername;

    @Property(required = false, description = "Email address to associate commits with the remote account", category = "Configuration")
    String committerEmail;

    // ---

    @PublicApiMember
    public String getCommitterUsername() {
        return committerUsername;
    }

    public void setCommitterUsername(final String committerUsername) {
        this.committerUsername = committerUsername;
    }

    @PublicApiMember
    public String getCommitterEmail() {
        return committerEmail;
    }

    public void setCommitterEmail(final String committerEmail) {
        this.committerEmail = committerEmail;
    }
}
