package com.xebialabs.xlrelease.scm.connector.actors

import akka.actor.{Actor, ActorLogging, ActorRef}
import akka.cluster.pubsub.DistributedPubSub
import akka.cluster.pubsub.DistributedPubSubMediator.{Publish, Subscribe, SubscribeAck}
import com.xebialabs.xlrelease.domain.scm.connector.JGitConnectorConfig
import com.xebialabs.xlrelease.scm.connector.JGitConnector
import com.xebialabs.xlrelease.scm.connector.actors.JGitRepoCleanerActor.{Clean, CleanupNodeRequested}

object JGitRepoCleanerActor {

  sealed trait JGitRepoCleanerCommand

  case class Clean(config: JGitConnectorConfig) extends JGitRepoCleanerCommand

  case class CleanupNodeRequested(config: JGitConnectorConfig) extends JGitRepoCleanerCommand

}

trait JGitRepoCleanerActor extends Actor with ActorLogging

class NonClusteredJGitRepoCleanerActor extends JGitRepoCleanerActor {
  override def receive: Receive = {
    case Clean(config) =>
      JGitConnector.deleteRepo(config.getId)
  }
}

class ClusteredJGitRepoCleanerActor extends JGitRepoCleanerActor {
  val topicName = "ClusteredJGitRepoCleanerActor-cleanup"
  val mediator: ActorRef = DistributedPubSub(context.system).mediator
  mediator ! Subscribe(topicName, self)

  override def receive: Receive = {
    case Clean(config) =>
      mediator ! Publish(topicName, CleanupNodeRequested(config))
    case CleanupNodeRequested(config) =>
      JGitConnector.deleteRepo(config.getId)
    case SubscribeAck(Subscribe(topicName, None, _)) =>
      log.info(s"subscribing to topic '$topicName'")
  }
}
