/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scm.connector;

import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.scm.connector.GitHubOAuth2Token;
import com.xebialabs.xlrelease.domain.scm.connector.GitHubScmConnectorConfig;
import com.xebialabs.xlrelease.domain.scm.connector.GitHubScmCredential;
import com.xebialabs.xlrelease.domain.scm.connector.GitHubUsernamePasswordCredential;
import com.xebialabs.xlrelease.scm.connector.RestApiScmConnector;
import com.xebialabs.xlrelease.scm.connector.ScmBlobs;
import com.xebialabs.xlrelease.scm.connector.ScmException;
import com.xebialabs.xlrelease.scm.connector.ScmException$;
import com.xebialabs.xlrelease.scm.data.ValidatedCommitInfo;
import java.io.Serializable;
import org.kohsuke.github.AbuseLimitHandler;
import org.kohsuke.github.GHBlob;
import org.kohsuke.github.GHFileNotFoundException;
import org.kohsuke.github.GHRef;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTree;
import org.kohsuke.github.GHTreeBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.RateLimitHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001\u0002\u0006\f\u0001YA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\u0006I\u0001!\t!\n\u0005\tQ\u0001A)\u0019!C\u0005S!)A\b\u0001C){!)1\t\u0001C)\t\")A\r\u0001C)K\")A\u000e\u0001C\u0005[\")!\u000f\u0001C\u0005g\"9\u0011q\u0002\u0001\u0005\n\u0005E!AE$ji\"+(mU2n\u0007>tg.Z2u_JT!\u0001D\u0007\u0002\u0013\r|gN\\3di>\u0014(B\u0001\b\u0010\u0003\r\u00198-\u001c\u0006\u0003!E\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005I\u0019\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005!\u0012aA2p[\u000e\u00011C\u0001\u0001\u0018!\tA\u0012$D\u0001\f\u0013\tQ2BA\nSKN$\u0018\t]5TG6\u001cuN\u001c8fGR|'/\u0001\u0004d_:4\u0017n\u001a\t\u0003;\tj\u0011A\b\u0006\u0003\u0019}Q!A\u0004\u0011\u000b\u0005\u0005z\u0011A\u00023p[\u0006Lg.\u0003\u0002$=\tAr)\u001b;Ik\n\u001c6-\\\"p]:,7\r^8s\u0007>tg-[4\u0002\rqJg.\u001b;?)\t1s\u0005\u0005\u0002\u0019\u0001!)1D\u0001a\u00019\u0005)qL]3q_V\t!\u0006E\u0002,aIj\u0011\u0001\f\u0006\u0003[9\nA!\u001e;jY*\tq&A\u0003tG\u0006d\u0017-\u0003\u00022Y\t\u0019AK]=\u0011\u0005MRT\"\u0001\u001b\u000b\u0005U2\u0014AB4ji\",(M\u0003\u00028q\u000591n\u001c5tk.,'\"A\u001d\u0002\u0007=\u0014x-\u0003\u0002<i\taq\t\u0013*fa>\u001c\u0018\u000e^8ss\u0006qA/Z:u%\u0016\u0004xn]5u_JLX#\u0001 \u0011\u0007-\u0002t\b\u0005\u0002A\u00036\ta&\u0003\u0002C]\t!QK\\5u\u00031\u0019w.\\7ji\u0006sG\rV1h)\u0011)\u0015K\u00160\u0011\u0007-\u0002d\t\u0005\u0002H\u001d:\u0011\u0001\n\u0014\t\u0003\u0013:j\u0011A\u0013\u0006\u0003\u0017V\ta\u0001\u0010:p_Rt\u0014BA'/\u0003\u0019\u0001&/\u001a3fM&\u0011q\n\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055s\u0003\"\u0002*\u0006\u0001\u0004\u0019\u0016!\u00022m_\n\u001c\bC\u0001\rU\u0013\t)6B\u0001\u0005TG6\u0014En\u001c2t\u0011\u00159V\u00011\u0001Y\u0003)\u0019w.\\7ji&sgm\u001c\t\u00033rk\u0011A\u0017\u0006\u000376\tA\u0001Z1uC&\u0011QL\u0017\u0002\u0014-\u0006d\u0017\u000eZ1uK\u0012\u001cu.\\7ji&sgm\u001c\u0005\u0006?\u0016\u0001\r\u0001Y\u0001\u0005kN,'\u000f\u0005\u0002bE6\t\u0001%\u0003\u0002dA\tYQk]3s!J|g-\u001b7f\u00035!\u0018m\u001a(piB\u0013Xm]3oiR\u0011aM\u001b\t\u0004WA:\u0007C\u0001!i\u0013\tIgFA\u0004C_>dW-\u00198\t\u000b-4\u0001\u0019\u0001$\u0002\u0007Q\fw-\u0001\u0006uef\u001cuN\u001c8fGR$\u0012A\u001c\t\u0004WAz\u0007CA\u001aq\u0013\t\tHG\u0001\u0004HSRDUOY\u0001\fkBdw.\u00193CY>\u00147\u000fF\u0003u\u0003\u0013\tY\u0001E\u0002,aU\u00042A^>\u007f\u001d\t9\u0018P\u0004\u0002Jq&\tq&\u0003\u0002{]\u00059\u0001/Y2lC\u001e,\u0017B\u0001?~\u0005\u0011a\u0015n\u001d;\u000b\u0005it\u0003#\u0002!\u0000\r\u0006\r\u0011bAA\u0001]\t1A+\u001e9mKJ\u00022aMA\u0003\u0013\r\t9\u0001\u000e\u0002\u0007\u000f\"\u0013En\u001c2\t\u000bIC\u0001\u0019A*\t\r\u00055\u0001\u00021\u00013\u0003\u0011\u0011X\r]8\u0002\u0015\r\u0014X-\u0019;f)J,W\r\u0006\u0005\u0002\u0014\u0005m\u0011QDA\u0011!\u0011Y\u0003'!\u0006\u0011\u0007M\n9\"C\u0002\u0002\u001aQ\u0012aa\u0012%Ue\u0016,\u0007BBA\u0007\u0013\u0001\u0007!\u0007\u0003\u0004\u0002 %\u0001\rAR\u0001\fE\u0006\u001cX\r\u0016:fKNC\u0017\r\u0003\u0004S\u0013\u0001\u0007\u00111\u0005\t\u0005m\u0006\u0015b0C\u0002\u0002(u\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a")
public class GitHubScmConnector
extends RestApiScmConnector {
    private Try<GHRepository> _repo;
    private final GitHubScmConnectorConfig config;
    private volatile boolean bitmap$0;

    private Try<GHRepository> _repo$lzycompute() {
        GitHubScmConnector gitHubScmConnector = this;
        synchronized (gitHubScmConnector) {
            if (!this.bitmap$0) {
                Try repo = this.tryConnect().map((Function1 & Serializable)gh -> gh.getRepository($this.config.repository()));
                this._repo = repo.recoverWith((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        HttpException httpException;
                        A1 A1 = x1;
                        if (A1 instanceof GHFileNotFoundException) {
                            GHFileNotFoundException gHFileNotFoundException = (GHFileNotFoundException)A1;
                            return (B1)new Failure((Throwable)((Object)new ScmException("Repository not found", (Throwable)gHFileNotFoundException, 404)));
                        }
                        if (A1 instanceof HttpException && (httpException = (HttpException)A1).getResponseCode() == 401) {
                            return (B1)new Failure((Throwable)((Object)new ScmException("Invalid credentials", (Throwable)httpException, 401)));
                        }
                        if (A1 instanceof Exception) {
                            Exception exception = (Exception)A1;
                            return (B1)new Failure((Throwable)((Object)new ScmException(exception.getMessage(), ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3())));
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        HttpException httpException;
                        Throwable throwable = x1;
                        if (throwable instanceof GHFileNotFoundException) {
                            return true;
                        }
                        if (throwable instanceof HttpException && (httpException = (HttpException)throwable).getResponseCode() == 401) {
                            return true;
                        }
                        return throwable instanceof Exception;
                    }
                });
                this.bitmap$0 = true;
            }
        }
        return this._repo;
    }

    private Try<GHRepository> _repo() {
        if (!this.bitmap$0) {
            return this._repo$lzycompute();
        }
        return this._repo;
    }

    @Override
    public Try<BoxedUnit> testRepository() {
        return this._repo().map((Function1 & Serializable)x$1 -> {
            GitHubScmConnector.$anonfun$testRepository$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Try<String> commitAndTag(ScmBlobs blobs, ValidatedCommitInfo commitInfo, UserProfile user) {
        return this._repo().flatMap((Function1 & Serializable)repo -> Try$.MODULE$.apply((Function0 & Serializable)() -> repo.getRef("heads/" + $this.config.branch())).recoverWith((PartialFunction)new Serializable(this, (GHRepository)repo){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ GitHubScmConnector $outer;
            private final GHRepository repo$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                HttpException httpException;
                A1 A1 = x1;
                if (A1 instanceof HttpException && (httpException = (HttpException)A1).getResponseCode() == 200 && httpException.getCause().getCause() instanceof MismatchedInputException) {
                    return (B1)this.$outer.com$xebialabs$xlrelease$scm$connector$GitHubScmConnector$$createBranch$1(this.repo$2);
                }
                if (A1 instanceof GHFileNotFoundException) {
                    return (B1)this.$outer.com$xebialabs$xlrelease$scm$connector$GitHubScmConnector$$createBranch$1(this.repo$2);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                HttpException httpException;
                Throwable throwable = x1;
                if (throwable instanceof HttpException && (httpException = (HttpException)throwable).getResponseCode() == 200 && httpException.getCause().getCause() instanceof MismatchedInputException) {
                    return true;
                }
                return throwable instanceof GHFileNotFoundException;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.repo$2 = repo$2;
            }
        }).flatMap((Function1 & Serializable)headRef -> Try$.MODULE$.apply((Function0 & Serializable)() -> repo.getTree($this.config.branch())).flatMap((Function1 & Serializable)baseTree -> this.uploadBlobs(blobs, (GHRepository)repo).flatMap((Function1 & Serializable)ghNamedBlobs -> this.createTree((GHRepository)repo, baseTree.getSha(), (Iterable<Tuple2<String, GHBlob>>)ghNamedBlobs).flatMap((Function1 & Serializable)newTree -> Try$.MODULE$.apply((Function0 & Serializable)() -> repo.createCommit().message(commitInfo.message()).tree(newTree.getSha()).parent(headRef.getObject().getSha()).create()).flatMap((Function1 & Serializable)commit -> Try$.MODULE$.apply((Function0 & Serializable)() -> repo.createRef(commitInfo.tag().toString(), commit.getSHA1())).flatMap((Function1 & Serializable)x$3 -> {
            GHRef gHRef = x$3;
            return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> headRef.updateTo(commit.getSHA1())).map((Function1 & Serializable)x$2 -> {
                BoxedUnit boxedUnit = x$2;
                return commit.getSHA1();
            });
        })))))));
    }

    @Override
    public Try<Object> tagNotPresent(String tag) {
        return this._repo().map((Function1 & Serializable)repo -> BoxesRunTime.boxToBoolean((boolean)GitHubScmConnector.$anonfun$tagNotPresent$1(tag, repo)));
    }

    private Try<GitHub> tryConnect() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            GitHubBuilder builder = new GitHubBuilder().withRateLimitHandler(RateLimitHandler.FAIL).withAbuseLimitHandler(AbuseLimitHandler.FAIL).withEndpoint($this.config.restApiUrl());
            GitHubScmCredential gitHubScmCredential = $this.config.credential();
            if (gitHubScmCredential instanceof GitHubUsernamePasswordCredential) {
                GitHubUsernamePasswordCredential gitHubUsernamePasswordCredential = (GitHubUsernamePasswordCredential)gitHubScmCredential;
                builder.withPassword(gitHubUsernamePasswordCredential.username(), PasswordEncrypter.getInstance().ensureDecrypted(gitHubUsernamePasswordCredential.password()));
            } else if (gitHubScmCredential instanceof GitHubOAuth2Token) {
                GitHubOAuth2Token gitHubOAuth2Token = (GitHubOAuth2Token)gitHubScmCredential;
                builder.withOAuthToken(PasswordEncrypter.getInstance().ensureDecrypted(gitHubOAuth2Token.token()));
            } else {
                if (gitHubScmCredential == null) {
                    throw new IllegalStateException("No credential provided for GitHub SCM config '" + $this.config.getTitle() + "'.");
                }
                throw new MatchError((Object)gitHubScmCredential);
            }
            return builder.build();
        });
    }

    private Try<List<Tuple2<String, GHBlob>>> uploadBlobs(ScmBlobs blobs, GHRepository repo) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ListBuffer ghBlobs = ListBuffer$.MODULE$.empty();
            blobs.filesToAdd().foreach((Function1 & Serializable)file -> (ListBuffer)ghBlobs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file.absolutePath()), (Object)repo.createBlob().binaryContent((byte[])file.getContent().apply()).create())));
            return ghBlobs.toList();
        });
    }

    private Try<GHTree> createTree(GHRepository repo, String baseTreeSha, Iterable<Tuple2<String, GHBlob>> blobs) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            GHTreeBuilder builder = repo.createTree().baseTree(baseTreeSha);
            blobs.foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String filename = (String)tuple2._1();
                    GHBlob ghBlob = (GHBlob)tuple2._2();
                    return builder.shaEntry(filename, ghBlob.getSha(), false);
                }
                throw new MatchError((Object)tuple2);
            });
            return builder.create();
        });
    }

    public static final /* synthetic */ void $anonfun$testRepository$1(GHRepository x$1) {
    }

    public final Try com$xebialabs$xlrelease$scm$connector$GitHubScmConnector$$createBranch$1(GHRepository repo) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            GHRef defaultBranch = repo.getRef("heads/" + repo.getDefaultBranch());
            return repo.createRef("refs/heads/" + $this.config.branch(), defaultBranch.getObject().getSha());
        });
    }

    public static final /* synthetic */ boolean $anonfun$tagNotPresent$1(String tag$1, GHRepository repo) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> repo.getRef("tags/" + tag$1)).failed().isSuccess();
    }

    public GitHubScmConnector(GitHubScmConnectorConfig config) {
        this.config = config;
        super(config);
    }
}

