/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scm.connector;

import com.xebialabs.xlrelease.scm.connector.GitClient;
import com.xebialabs.xlrelease.scm.connector.GitConnectionSettings;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.transport.http.HttpConnectionFactory;
import org.eclipse.jgit.transport.http.apache.HttpClientConnection;

public class XlrGitHttpConnectionFactory
implements HttpConnectionFactory {
    XlrGitHttpConnectionFactory() {
    }

    public HttpConnection create(URL url) throws IOException {
        return new HttpClientConnection(url.toString(), null, this.createClient());
    }

    public HttpConnection create(URL url, Proxy proxy) throws IOException {
        return new HttpClientConnection(url.toString(), null, this.createClient());
    }

    private HttpClient createClient() {
        GitConnectionSettings gitConnectionSettings = GitClient.currentGitConnectionSettings.get();
        HttpClientBuilder clientBuilder = HttpClients.custom();
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setCookieSpec("standard");
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (gitConnectionSettings.shouldUseAuthentication()) {
            switch (gitConnectionSettings.getAuthenticationMethod()) {
                case "Basic": {
                    String basicAuthorization = Base64.encodeBase64String((byte[])String.format("%s:%s", gitConnectionSettings.getUsername(), gitConnectionSettings.getPassword()).getBytes(StandardCharsets.UTF_8));
                    clientBuilder.setDefaultHeaders(Collections.singletonList(new BasicHeader("Authorization", String.format("Basic %s", basicAuthorization))));
                    break;
                }
                case "Ntlm": {
                    configBuilder.setTargetPreferredAuthSchemes(Collections.singletonList("NTLM"));
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(gitConnectionSettings.getUsername(), gitConnectionSettings.getPassword(), null, gitConnectionSettings.getDomain()));
                    break;
                }
                case "PAT": {
                    String patAuthorization = Base64.encodeBase64String((byte[])String.format(":%s", gitConnectionSettings.getPassword()).getBytes(StandardCharsets.UTF_8));
                    clientBuilder.setDefaultHeaders(Collections.singletonList(new BasicHeader("Authorization", String.format("Basic %s", patAuthorization))));
                }
            }
        }
        if (gitConnectionSettings.shouldUseProxy()) {
            clientBuilder.setProxy(new HttpHost(gitConnectionSettings.getProxyHost(), gitConnectionSettings.getProxyPort().intValue()));
            if (gitConnectionSettings.shouldUseProxyAuthentication()) {
                Object credentials = gitConnectionSettings.shouldUseNtlmProxyAuthentication() ? new NTCredentials(gitConnectionSettings.getProxyUsername(), gitConnectionSettings.getProxyPassword(), null, gitConnectionSettings.getProxyDomain()) : new UsernamePasswordCredentials(gitConnectionSettings.getProxyUsername(), gitConnectionSettings.getProxyPassword());
                AuthScope authScope = new AuthScope(gitConnectionSettings.getProxyHost(), gitConnectionSettings.getProxyPort().intValue());
                credentialsProvider.setCredentials(authScope, (Credentials)credentials);
            }
        }
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        clientBuilder.setDefaultRequestConfig(configBuilder.build());
        return clientBuilder.build();
    }
}

