package com.xebialabs.xlrelease.domain.scm.connector

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlrelease.scm.connector.GitHubScmConnector

import scala.beans.BeanProperty

@Metadata(label = "GitHub", description = "GitHub connector configuration")
class GitHubScmConnectorConfig extends RestApiScmConnectorConfig[GitHubScmCredential] {

  @BeanProperty
  @Property(label = "Credentials", description = "Select the type of credentials to access the GitHub repository")
  var credential: GitHubScmCredential = _

  override def getConnector = new GitHubScmConnector(this)
}

abstract class GitHubScmCredential extends ScmCredential {
  @BeanProperty
  @Property(asContainment = true)
  var config: GitHubScmConnectorConfig = _
}

@Metadata(label = "Username and password")
class GitHubUsernamePasswordCredential extends GitHubScmCredential {
  @BeanProperty
  @Property(description = "The GitHub repository login ID")
  var username: String = _

  @BeanProperty
  @Property(description = "The GitHub repository password", password = true)
  var password: String = _
}

@Metadata(label = "Personal access token")
class GitHubOAuth2Token extends GitHubScmCredential {
  @BeanProperty
  @Property(description = "The OAuth2 user access token for GitHub", password = true)
  var token: String = _
}
