package com.xebialabs.xlrelease.domain.scm.connector

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlrelease.scm.connector.GitLabScmConnector

import scala.beans.BeanProperty

@Metadata(label = "GitLab", description = "GitLab connector configuration")
class GitLabScmConnectorConfig extends RestApiScmConnectorConfig[GitLabScmCredential] {
  @BeanProperty
  @Property(label = "Credentials", description = "Select the type of credentials to access the GitLab repository")
  var credential: GitLabScmCredential = _

  override def getConnector = new GitLabScmConnector(this)
}

abstract class GitLabScmCredential extends ScmCredential {
  @BeanProperty
  @Property(asContainment = true)
  var config: GitLabScmConnectorConfig = _
}

@Metadata(label = "Personal access token")
class GitLabAPIKey extends GitLabScmCredential {
  @BeanProperty
  @Property(description = "The GitLab personal access token", password = true)
  var token: String = _
}
