package com.xebialabs.xlrelease.domain.scm.connector

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlrelease.domain.configuration.HttpConnection.AuthenticationMethod
import com.xebialabs.xlrelease.scm.connector.DefaultJGitConnector

import scala.beans.BeanProperty

@Metadata(label = "Git", description = "Git connector configuration")
class JGitConnectorConfig extends BaseScmConnectorConfig {

  @BeanProperty
  @Property(label = "Repository URL",
    description = "Full URL of git repository on which changes will be stored (e.g. http://your_bitbucket_server/scm/your_organization/your_repository.git)")
  var url: String = _

  @BeanProperty
  @Property(label = "Branch", description = "Branch on which changes will be stored")
  var branch = "master"

  @BeanProperty
  @Property(label = "Authentication method", defaultValue = "Basic")
  var authenticationMethod = AuthenticationMethod.Basic

  @BeanProperty
  @Property(required = false, description = "Login user ID on the server", category = "Authentication")
  var username: String = _

  @BeanProperty
  @Property(password = true, required = false, description = "Login user password on the server", category = "Authentication")
  var password: String = _

  @BeanProperty
  @Property(description = "Domain to be used for NTLM authentication", required = false, label = "Domain", category = "Authentication")
  var domain: String = _

  @BeanProperty
  @Property(required = false, label = "Proxy host", description = "HTTP proxy host", category = "Proxy")
  var proxyHost: String = _

  @BeanProperty
  @Property(required = false, label = "Proxy port", description = "HTTP proxy port", category = "Proxy")
  var proxyPort: String = _

  @BeanProperty
  @Property(required = false, label = "Proxy username", description = "HTTP proxy username", category = "Proxy")
  var proxyUsername: String = _

  @BeanProperty
  @Property(password = true, required = false, label = "Proxy password", description = "HTTP proxy password", category = "Proxy")
  var proxyPassword: String = _

  @BeanProperty
  @Property(required = false, label = "Proxy domain", description = "Domain to be used for NTLM proxy authentication", category = "Proxy")
  var proxyDomain: String = _

  @BeanProperty
  @Property(required = false, label = "Committer username", description = "Username that is associated with the Git commits", category = "Configuration")
  var committerUsername: String = _

  @BeanProperty
  @Property(required = false, label = "Committer email", description = "Email address to associate commits with the remote account", category = "Configuration")
  var committerEmail: String = _

  override def getConnector: DefaultJGitConnector = new DefaultJGitConnector(this)
}
