package com.xebialabs.xlrelease.scm.connector

import com.xebialabs.xlrelease.domain.UserProfile
import com.xebialabs.xlrelease.scm.data.ValidatedCommitInfo

import scala.util.{Success, Try}

class NoOpScmConnector extends ScmConnector {
  override def close(): Unit = {
    // nothing to close
  }

  override def connectionStatus(): Try[Unit] = Success(())

  override protected def commitAndTag(blobs: ScmBlobs, commitInfo: ValidatedCommitInfo, user: UserProfile): Try[String] = Success("")

  override protected def tagNotPresent(tag: String): Try[Boolean] = Success(true)

  override def getIdentifier(uniqueString: String): String = uniqueString
}
