package com.xebialabs.xlrelease.scm.connector

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.domain.Configuration
import com.xebialabs.xlrelease.domain.scm.connector.{BaseScmConnectorConfig, NoScmConnectorConfig, ScmConnectorConfig}
import com.xebialabs.xlrelease.repository.IdMatchers.FolderId
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.service.SharedConfigurationService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.Primary
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

@Service
@Primary
@IsTransactional
class ScmConnectorService @Autowired()(sharedConfigurationService: SharedConfigurationService) {

  def findScmConnectorConfig(folderId: String): ScmConnectorConfig = {
    val optionalFolderId = folderId match {
      case FolderId(id) => Some(id)
      case rootId if Ids.isRoot(rootId) => Some(Ids.ROOT_FOLDER_ID)
      case _ => None
    }
    optionalFolderId.flatMap { folderId =>
      val scmConfigType = Type.valueOf(classOf[BaseScmConnectorConfig])
      val scmConfigurations = sharedConfigurationService.searchByTypeAndTitle(scmConfigType, null, folderId, false).asScala
      scmConfigurations.sortBy(directoryDepth)(Ordering.Int.reverse)
        .headOption
    }.getOrElse(new NoScmConnectorConfig).asInstanceOf[ScmConnectorConfig]
  }

  private def directoryDepth(conf: Configuration): Int = {
    if (conf.getFolderId == null) 0 else conf.getFolderId.count(_ == '/')
  }
}
