package com.xebialabs.xlrelease.scm.connector.events.handler

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.events.{ConfigurationDeletedEvent, ConfigurationUpdatedEvent}
import com.xebialabs.xlrelease.domain.scm.connector.JGitConnectorConfig
import com.xebialabs.xlrelease.events.{AsyncSubscribe, EventListener, XLReleaseEventListener}
import com.xebialabs.xlrelease.scm.connector.actors.JGitRepoCleanerActor.Clean
import com.xebialabs.xlrelease.scm.connector.actors.{ClusteredJGitRepoCleanerActor, JGitRepoCleanerActor, NonClusteredJGitRepoCleanerActor}
import grizzled.slf4j.Logging
import org.apache.pekko.actor.Props
import org.springframework.stereotype.Service

@Service
@EventListener
class JGitConnectorConfigEventListener(xlrConfig: XlrConfig, actorSystemHolder: ActorSystemHolder) extends XLReleaseEventListener with Logging {
  private lazy val jGitRepoCleanerActor = {
    val props = if (xlrConfig.isClusterEnabled) {
      Props(new ClusteredJGitRepoCleanerActor())
    } else {
      Props(new NonClusteredJGitRepoCleanerActor())
    }
    actorSystemHolder.actorOf(props, JGitRepoCleanerActor.name)
  }

  private val jgitType = Type.valueOf(classOf[JGitConnectorConfig])

  @AsyncSubscribe
  def onConfigurationDelete(event: ConfigurationDeletedEvent): Unit = {
    if (event.conf.getType.instanceOf(jgitType)) {
      val config = event.conf.asInstanceOf[JGitConnectorConfig]
      jGitRepoCleanerActor ! Clean(config)
    }
  }

  @AsyncSubscribe
  def onConfigurationUpdate(event: ConfigurationUpdatedEvent): Unit = {
    if (event.updated.getType.instanceOf(jgitType)) {
      val config = event.updated.asInstanceOf[JGitConnectorConfig]
      jGitRepoCleanerActor ! Clean(config)
    }
  }
}
