/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.status.service;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.api.v1.ConfigurationApi;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.service.ConfigurationAutoconfigService;
import com.xebialabs.xlrelease.status.service.EndpointSetupDeploymentStatusService;
import com.xebialabs.xlrelease.status.service.WebhookBasicSetup;
import com.xebialabs.xlrelease.status.webhook.events.StatusWebhookEventSource;
import com.xebialabs.xlrelease.views.AutoconfigResponse;
import com.xebialabs.xlrelease.webhooks.authentication.NoAuthentication;
import com.xebialabs.xlrelease.webhooks.endpoint.WebhookEndpoint;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Service;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u00114Aa\u0002\u0005\u0001'!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u0015\u0011\u0004\u0001\"\u00114\u0011\u00151\u0005\u0001\"\u0003H\u0011\u0015\t\u0006\u0001\"\u0003S\u0005\u0005\u001aV\r^;q\u0003B\u0004H.[2bi&|gn\u0015;biV\u001c8+\u001a:wS\u000e,\u0017*\u001c9m\u0015\tI!\"A\u0004tKJ4\u0018nY3\u000b\u0005-a\u0011AB:uCR,8O\u0003\u0002\u000e\u001d\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u001fA\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003E\t1aY8n\u0007\u0001\u00192\u0001\u0001\u000b\u001b!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fMB\u00111\u0004H\u0007\u0002\u0011%\u0011Q\u0004\u0003\u0002%\u000b:$\u0007o\\5oiN+G/\u001e9EKBdw._7f]R\u001cF/\u0019;vgN+'O^5dK\u0006\u00012m\u001c8gS\u001e,(/\u0019;j_:\f\u0005/\u001b\t\u0003A\u0015j\u0011!\t\u0006\u0003E\r\n!A^\u0019\u000b\u0005\u0011b\u0011aA1qS&\u0011a%\t\u0002\u0011\u0007>tg-[4ve\u0006$\u0018n\u001c8Ba&\fadY8oM&<WO]1uS>t\u0017)\u001e;pG>tg-[4TKJ4\u0018nY3\u0011\u0005%ZS\"\u0001\u0016\u000b\u0005%a\u0011B\u0001\u0017+\u0005y\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006+Ho\\2p]\u001aLwmU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0004_A\n\u0004CA\u000e\u0001\u0011\u0015q2\u00011\u0001 \u0011\u001593\u00011\u0001)\u0003u\u0019X\r^;q\u0003B\u0004H.[2bi&|gn\u0015;biV\u001cx+\u001a2i_>\\Gc\u0001\u001b8\tB\u00111$N\u0005\u0003m!\u0011\u0011cV3cQ>|7NQ1tS\u000e\u001cV\r^;q\u0011\u0015AD\u00011\u0001:\u0003!\u0019XM\u001d<fe&#\u0007C\u0001\u001eB\u001d\tYt\b\u0005\u0002=-5\tQH\u0003\u0002?%\u00051AH]8pizJ!\u0001\u0011\f\u0002\rA\u0013X\rZ3g\u0013\t\u00115I\u0001\u0004TiJLgn\u001a\u0006\u0003\u0001ZAQ!\u0012\u0003A\u0002e\n\u0001BZ8mI\u0016\u0014\u0018\nZ\u0001\u001dGJ,\u0017\r^3IiR\u0004XI\u001c3q_&tGOR8s/\u0016\u0014\u0007n\\8l)\rAej\u0014\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u00172\ta\u0001Z8nC&t\u0017BA'K\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")Q)\u0002a\u0001s!)\u0001+\u0002a\u0001s\u0005)A/\u001b;mK\u0006I2M]3bi\u0016\u001cF/\u0019;vg^+'\r[8pWN{WO]2f)\u0015A5\u000bV+X\u0011\u0015)e\u00011\u0001:\u0011\u0015\u0001f\u00011\u0001:\u0011\u00151f\u00011\u0001I\u0003-)g/\u001a8u'>,(oY3\t\u000ba3\u0001\u0019\u0001%\u0002\u0019M|WO]2f'\u0016\u0014h/\u001a:)\u0005\u0001Q\u0006CA.c\u001b\u0005a&BA/_\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0003?\u0002\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002C\u0006\u0019qN]4\n\u0005\rd&aB*feZL7-\u001a")
public class SetupApplicationStatusServiceImpl
implements EndpointSetupDeploymentStatusService {
    private final ConfigurationApi configurationApi;
    private final ConfigurationAutoconfigService configurationAutoconfigService;

    @Override
    public WebhookBasicSetup setupApplicationStatusWebhook(String serverId, String folderId) {
        Configuration server = this.configurationApi.getConfiguration(serverId);
        List serverWebhookEndpoints = this.configurationApi.searchByTypeAndTitle("events.PostWebhookEndpoint", server.getTitle(), folderId, true);
        Configuration webhookEndpoint = !serverWebhookEndpoints.isEmpty() ? (Configuration)serverWebhookEndpoints.get(0) : this.createHttpEndpointForWebhook(folderId, server.getTitle());
        Configuration statusWebhookSource = this.createStatusWebhookSource(folderId, server.getTitle(), webhookEndpoint, server);
        AutoconfigResponse autoconfigResponse = this.configurationAutoconfigService.autoconfigure(statusWebhookSource);
        return new WebhookBasicSetup(Predef$.MODULE$.Boolean2boolean(autoconfigResponse.getSuccess()), autoconfigResponse.getMessage(), autoconfigResponse.getDetails(), autoconfigResponse.getUrl(), statusWebhookSource.getId());
    }

    private Configuration createHttpEndpointForWebhook(String folderId, String title) {
        WebhookEndpoint.PostWebhookEndpoint webhookEndpoint = (WebhookEndpoint.PostWebhookEndpoint)Type.valueOf(WebhookEndpoint.PostWebhookEndpoint.class).getDescriptor().newInstance("post-webhook-endpoint");
        webhookEndpoint.setTitle(title);
        webhookEndpoint.setFolderId(folderId);
        webhookEndpoint.setProperty("path", (Object)new StringBuilder(5).append("path-").append(UUID.randomUUID()).toString());
        webhookEndpoint.setProperty("authentication", (Object)new NoAuthentication());
        return this.configurationApi.addConfiguration((Configuration)webhookEndpoint);
    }

    private Configuration createStatusWebhookSource(String folderId, String title, Configuration eventSource, Configuration sourceServer) {
        Type type = sourceServer.getType();
        Type type2 = Type.valueOf((String)"xldeploy.XLDeployServer");
        String statusWebhookEventSourceType = !(type != null ? !type.equals(type2) : type2 != null) ? "xldeploy.StatusWebhookEventSource" : "argocd.StatusWebhookEventSource";
        StatusWebhookEventSource statusWebhookEventSource = (StatusWebhookEventSource)Type.valueOf((String)statusWebhookEventSourceType).getDescriptor().newInstance("status-event-webhook");
        statusWebhookEventSource.setTitle(title);
        statusWebhookEventSource.setFolderId(folderId);
        statusWebhookEventSource.setProperty("eventSource", eventSource);
        statusWebhookEventSource.setProperty("sourceServer", sourceServer);
        return this.configurationApi.addConfiguration((Configuration)statusWebhookEventSource);
    }

    public SetupApplicationStatusServiceImpl(ConfigurationApi configurationApi, ConfigurationAutoconfigService configurationAutoconfigService) {
        this.configurationApi = configurationApi;
        this.configurationAutoconfigService = configurationAutoconfigService;
    }
}

