import React from 'react';
import { DotButton, DotIcon } from '@digital-ai/dot-components';
import { ActionToolbarPortalContainer } from '../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { Folder } from '../../../../../../../../../core/xlr-ui/app/types';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../core/xlr-ui/app/js/hooks';
import { folderExternalDeployments } from '../ducks/external-deployments.reducer';
import { getExternalDeploymentPageSelector } from '../ducks/external-deployments.selectors';

export interface ApplicationsTableComponentPortalProp {
    folder: Folder;
    onViewChange: () => void;
    reSyncEnabled: boolean;
}

const { loadExternalDeployments } = folderExternalDeployments.actions;

export const ExternalDeploymentComponentPortal = (props: ApplicationsTableComponentPortalProp) => {
    const page = useAppSelector(getExternalDeploymentPageSelector);

    const { onViewChange, reSyncEnabled, folder } = props;
    const dispatch = useAppDispatch();

    return (
        <ActionToolbarPortalContainer>
            <DotButton
                disabled={!reSyncEnabled}
                onClick={() =>
                    dispatch(
                        loadExternalDeployments({
                            folderId: folder.id,
                            order: page.order,
                            orderBy: page.orderBy,
                            page: page.page,
                            resultsPerPage: page.resultsPerPage,
                        }),
                    )
                }
                startIcon={<DotIcon iconId="sync" />}
                type="outlined"
            >
                Re-synch
            </DotButton>
            <DotButton onClick={() => onViewChange()}> Discover applications </DotButton>
        </ActionToolbarPortalContainer>
    );
};
