import React from 'react';
import { useState, useEffect } from 'react';
import { ExternalDeploymentsTable } from './external-deployments-table.component';
import { WizardSetup } from './wizard/application-wizard-setup-component';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../core/xlr-ui/app/js/hooks';
import { WebhookSource } from '../external-deployment.types';
import { getWebhookSourcesSelector } from '../ducks/external-deployments.selectors';
import { folderExternalDeployments } from '../ducks/external-deployments.reducer';
import { FolderExternalDeploymentsProps } from './folder-external-deployments';
import { DEFAULT_ORDER, DEFAULT_ORDER_BY, DEFAULT_PAGE, DEFAULT_RESULTS_PER_PAGE } from '../constants';

const { loadExternalDeployments } = folderExternalDeployments.actions;

export const FolderExternalDeploymentsWrapper = ({ folder }: FolderExternalDeploymentsProps) => {
    const webhookSources: Array<WebhookSource> = useAppSelector(getWebhookSourcesSelector);

    const [isWizardView, setIsWizardView] = useState<boolean>(false);
    const dispatch = useAppDispatch();

    useEffect(() => {
        loadApplicationTable();
    }, [webhookSources]);

    const loadApplicationTable = () => {
        dispatch(
            loadExternalDeployments({
                folderId: folder.id,
                order: DEFAULT_ORDER,
                orderBy: DEFAULT_ORDER_BY,
                page: DEFAULT_PAGE,
                resultsPerPage: DEFAULT_RESULTS_PER_PAGE,
            }),
        );
    };

    const closeWizard = () => {
        setIsWizardView(false);
    };

    return (
        <>
            {!isWizardView ? (
                <ExternalDeploymentsTable folder={folder} onViewChange={() => setIsWizardView(true)} />
            ) : (
                <WizardSetup folder={folder} onViewChange={closeWizard} />
            )}
        </>
    );
};
