import React from 'react';
import { ReactWrapper } from 'enzyme';
import { mountWithStoreAndTheme } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { WizardSetup } from './application-wizard-setup-component';
import { IMG_SRC } from '../../constants';
import { FolderExternalDeploymentsState, initialState } from '../../ducks/external-deployments.reducer';

const dispatch = jest.fn();
describe('Wizard setup component', () => {
    let wrapper: ReactWrapper;
    const onViewChange = jest.fn();
    const defaultProps = {
        folder: { id: 'folderId', title: 'Folder-1' },
        onViewChange,
    };
    const defaultState = {
        ...initialState,
    };
    const mountComponent = (state: FolderExternalDeploymentsState = defaultState) => {
        wrapper = mountWithStoreAndTheme(<WizardSetup {...defaultProps} />, dispatch, { folderExternalDeployments: state });
    };

    const discoveryButton = () => wrapper.find(`button[data-testid="wizard-setup-discovery-button"]`);

    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should show the wizard image', () => {
        expect(wrapper.find(`img`).prop('src')).toStrictEqual(IMG_SRC.wizardSetup);
    });

    it("should show the 'Discover applications' button", () => {
        expect(discoveryButton()).toExist();
        expect(discoveryButton().text()).toStrictEqual('Discover applications');
    });

    it('should handle discover applications button click', () => {
        expect(wrapper).not.toContainMatchingElement(`div .discovery`);
        discoveryButton().simulate('click');
        expect(wrapper).toContainMatchingElement(`div .discovery`);
    });
});
