import React, { useState, memo } from 'react';
import { IMG_SRC } from '../../constants';
import './application-wizard-setup-component.less';
import { DotButton, DotThemeProvider } from '@digital-ai/dot-components';
import { Folder } from '../../../../../../../../../../core/xlr-ui/app/types';
import { ApplicationsDiscovery } from './applications-discovery-component';

export interface FolderApplicationsWizardSetupProps {
    folder: Folder;
    onViewChange: () => void;
}

const WizardSetupComponent = (props: FolderApplicationsWizardSetupProps) => {
    const { folder, onViewChange } = props;
    const [discoverApps, setDiscoverApps] = useState<boolean>();

    const generateChoice = () => {
        return (
            <div className="setup-wizard">
                <img src={IMG_SRC.wizardSetup} />
                <div className="bottom-part">
                    <h2>Applications</h2>
                    <p>Create a query to see what applications you would like to see and find your scope.</p>
                    <div>
                        <DotButton data-testid="wizard-setup-discovery-button" onClick={() => setDiscoverApps(true)} type="primary">
                            Discover applications
                        </DotButton>
                    </div>
                </div>
            </div>
        );
    };

    const closeWizard = () => {
        setDiscoverApps(false);
        onViewChange();
    };

    return (
        <DotThemeProvider>
            {discoverApps && <ApplicationsDiscovery folder={folder} onCancel={closeWizard} onSave={onViewChange} />}
            {!discoverApps && generateChoice()}
        </DotThemeProvider>
    );
};

export const WizardSetup = memo(WizardSetupComponent);
