import React, { useEffect, useState, memo } from 'react';
import { DotThemeProvider } from '@digital-ai/dot-components';
import './applications-discovery-component.less';
import { BasicDiscovery } from './basic-wizard/application-discovery-basic-component';
import { Folder } from '../../../../../../../../../../core/xlr-ui/app/types';
import { Server, WebhookSource } from '../../external-deployment.types';
import { folderExternalDeployments } from '../../ducks/external-deployments.reducer';
import { getIsLoadingSelector, getServersSelector, getWebhookSourcesSelector } from '../../ducks/external-deployments.selectors';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';

export interface FolderApplicationsDiscoveryProps {
    folder: Folder;
    onCancel: () => void;
    onSave: () => void;
}

const { loadServers, loadWebhookSources } = folderExternalDeployments.actions;

const ApplicationDiscoveryComponent = (props: FolderApplicationsDiscoveryProps) => {
    const { folder, onCancel, onSave } = props;

    const isLoading: boolean = useAppSelector(getIsLoadingSelector);
    const servers: Array<Server> = useAppSelector(getServersSelector);
    const webhookSources: Array<WebhookSource> = useAppSelector(getWebhookSourcesSelector);

    const [advancedSetup, setAdvancedSetup] = useState(true);

    const dispatch = useAppDispatch();

    useEffect(() => {
        dispatch(loadServers(folder.id));
        dispatch(loadWebhookSources(folder.id));
    }, []);

    const onSetupChange = () => setAdvancedSetup(!advancedSetup);

    return (
        <DotThemeProvider>
            <div className="discovery">
                <BasicDiscovery
                    folder={folder}
                    isLoading={isLoading}
                    onCancel={onCancel}
                    onChange={onSetupChange}
                    onSave={onSave}
                    servers={servers}
                    webhookSources={webhookSources}
                />
            </div>
        </DotThemeProvider>
    );
};

export const ApplicationsDiscovery = memo(ApplicationDiscoveryComponent);
