import { AutoCompleteOption } from '@digital-ai/dot-components/lib/components/auto-complete/AutoComplete';
import { Authentication } from '../../../../../../../../core/xlr-ui/app/types';
import { Order, RowsPerPageOption } from '@digital-ai/dot-components';

export declare type PillStatus = 'success' | 'error' | 'warning' | 'in-progress' | 'default';

export interface VersionState {
    label: string;
    state?: string;
}

export interface DeploymentState {
    deploymentStatus: string;
    deploymentType: string;
    destination: string;
    lastChangeTime?: Date;
    namespace: string;
    user: string;
    versionTag: VersionState;
}

export interface ExternalDeployment {
    applicationName: string;
    applicationPath: string;
    applicationUid: string;
    endpointId: string;
    state: DeploymentState;
    statusGroup: PillStatus;
}

export interface ConnectionServer {
    id: string;
    name: string;
    type: string;
    url: string;
}

export interface Server {
    accessTokenUrl?: string;
    authToken?: string;
    authenticationMethod: string;
    clientId?: string;
    clientSecret?: string;
    domain?: string;
    folderId: string;
    id: string | null;
    password?: string;
    proxyDomain?: string;
    proxyHost?: string;
    proxyPassword?: string;
    proxyPort?: number;
    proxyUsername?: string;
    scope?: string;
    title: string;
    type: string;
    url: string;
    username?: string;
    variableMapping?: Map<string, string>;
}

export interface ExternalDeploymentPage {
    folderId?: string;
    order: Order;
    orderBy: string;
    page: number;
    resultsPerPage: RowsPerPageOption;
}

export interface ExternalDeploymentEvent {
    applicationUid: string;
    destinationUid: string;
}

export interface BaseExternalDeploymentEvent extends ExternalDeploymentEvent {
    applicationName: string;
    applicationPath: string;
    destination: string;
    destinationUid: string;
    namespace: string;
}

export interface CreateStatusEvent extends BaseExternalDeploymentEvent {
    statusGroup: string;
    versionTag: VersionState;
}

export interface DeleteStatusEvent extends BaseExternalDeploymentEvent {
    versionTag: VersionState;
}

export interface UpdateStatusEvent extends BaseExternalDeploymentEvent {
    state: DeploymentState;
    statusGroup: PillStatus;
}

export interface EndpointExternalDeploymentEvent<T extends ExternalDeploymentEvent> {
    endpointId: string;
    state: T;
}

export interface WebhookSource {
    consumerEnabled: boolean;
    eventSource: string | null;
    filteredApplications?: Array<string>;
    filteredFolders?: Array<string>;
    folderId: string;
    id: string | null;
    sourceServer: string | null;
    title: string;
    type: string;
    variableMapping?: Map<string, string>;
}

export interface WebhookSourceAutoConfigDetails {
    details: string;
    message: string;
    success: boolean;
    url: string;
    webhookSourceId: string;
}

export interface WebhookSourceFilter {
    folderFilterOptions: Array<string>;
    folderFilterValues: Array<string>;
    webhookSourceId: string;
}

export interface SetupLiveUpdateRequest {
    folderId: string;
    serverId: string;
}

export interface SaveWebhookSourceFiltersRequest {
    filteredFolders: string[];
    webhookSourceId: string;
}

export interface IdAutocompleteOption extends AutoCompleteOption {
    id: string;
}

export interface WebhookEndpoint {
    authentication: Authentication;
    folderId: string;
    id: string | null;
    method?: string;
    path?: string;
    requestRetention?: number;
    sourceEnabled: boolean;
    title: string;
    type?: string;
    variableMapping: Map<string, string>;
}
