package com.xebialabs.xlrelease.status.sse

import com.xebialabs.xlrelease.status.sse.service.ServerSentEventsService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.web.bind.annotation.{GetMapping, RequestMapping, RestController}
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter

import javax.servlet.http.HttpServletResponse
import javax.ws.rs.core.MediaType

@RequestMapping(Array("/sse"))
@RestController
class ServerSentEventsResource @Autowired()(val serverSentEventsService: ServerSentEventsService) {

  @GetMapping(path = Array("/application-status/register"), produces = Array(MediaType.SERVER_SENT_EVENTS))
  def registerExternalDeploymentStream(response: HttpServletResponse): SseEmitter = {
    response.setHeader("Cache-Control","no-cache,no-transform")
    serverSentEventsService.add()
  }
}
