import React from 'react';
import { ReactWrapper } from 'enzyme';
import { mountWithStoreAndTheme } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { WizardSetup } from './application-wizard-setup-component';
import { FolderExternalDeploymentsState, initialState } from '../../ducks/external-deployments.reducer';
import { ApplicationsDiscovery } from './applications-discovery-component';

const dispatch = jest.fn();
describe('Wizard setup component', () => {
    let wrapper: ReactWrapper;
    const onViewChange = jest.fn();
    const defaultProps = {
        folder: { id: 'folderId', title: 'Folder-1' },
        onViewChange,
    };
    const defaultState = {
        ...initialState,
    };
    const mountComponent = (state: FolderExternalDeploymentsState = defaultState) => {
        wrapper = mountWithStoreAndTheme(<WizardSetup {...defaultProps} />, dispatch, { folderExternalDeployments: state });
    };

    const applicationsDiscovery = () => wrapper.find(ApplicationsDiscovery);

    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should contain applications discovery component', () => {
        expect(applicationsDiscovery()).toExist();
    });
});
