/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.scm;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.versioning.scm.ScmConnectorService;
import com.xebialabs.xlrelease.versioning.scm.ScmTemplateToBlobsConverter;
import com.xebialabs.xlrelease.versioning.scm.connector.Blobs;
import com.xebialabs.xlrelease.versioning.scm.connector.ScmConnector;
import com.xebialabs.xlrelease.versioning.scm.connector.ScmConnectorConfig;
import com.xebialabs.xlrelease.versioning.scm.connector.ValidatedCommitInfo;
import com.xebialabs.xlrelease.versioning.scm.connector.ValidatedCommitInfo$;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0005\u00014Aa\u0002\u0005\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011!\u0019\u0003A!A!\u0002\u0013!\u0003\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u000b9\u0002A\u0011A\u0018\t\u000b\u0011\u0003A\u0011A#\u00033M\u001bW\u000eV3na2\fG/Z*u_J\fw-Z*feZL7-\u001a\u0006\u0003\u0013)\t1a]2n\u0015\tYA\"\u0001\u0006wKJ\u001c\u0018n\u001c8j]\u001eT!!\u0004\b\u0002\u0013ad'/\u001a7fCN,'BA\b\u0011\u0003%AXMY5bY\u0006\u00147OC\u0001\u0012\u0003\r\u0019w.\\\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VMZ\u0001\u0014g\u000el7i\u001c8oK\u000e$xN]*feZL7-\u001a\t\u00039ui\u0011\u0001C\u0005\u0003=!\u00111cU2n\u0007>tg.Z2u_J\u001cVM\u001d<jG\u0016\f1d]2n)\u0016l\u0007\u000f\\1uKR{'\t\\8cg\u000e{gN^3si\u0016\u0014\bC\u0001\u000f\"\u0013\t\u0011\u0003BA\u000eTG6$V-\u001c9mCR,Gk\u001c\"m_\n\u001c8i\u001c8wKJ$XM]\u0001\u000fe\u0016dW-Y:f'\u0016\u0014h/[2f!\t)\u0003&D\u0001'\u0015\t9C\"A\u0004tKJ4\u0018nY3\n\u0005%2#A\u0004*fY\u0016\f7/Z*feZL7-Z\u0001\u0013kN,'\u000f\u0015:pM&dWmU3sm&\u001cW\r\u0005\u0002&Y%\u0011QF\n\u0002\u0013+N,'\u000f\u0015:pM&dWmU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0006aE\u00124\u0007\u000e\t\u00039\u0001AQAG\u0003A\u0002mAQaH\u0003A\u0002\u0001BQaI\u0003A\u0002\u0011BQAK\u0003A\u0002-B#!\u0002\u001c\u0011\u0005]\u0012U\"\u0001\u001d\u000b\u0005eR\u0014AC1o]>$\u0018\r^5p]*\u00111\bP\u0001\bM\u0006\u001cGo\u001c:z\u0015\tid(A\u0003cK\u0006t7O\u0003\u0002@\u0001\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001B\u0003\ry'oZ\u0005\u0003\u0007b\u0012\u0011\"Q;u_^L'/\u001a3\u0002!\r\u0014X-\u0019;f\u001d\u0016<h+\u001a:tS>tG#\u0002$R'V;\u0006CA$O\u001d\tAE\n\u0005\u0002J-5\t!J\u0003\u0002L%\u00051AH]8pizJ!!\u0014\f\u0002\rA\u0013X\rZ3g\u0013\ty\u0005K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001bZAQA\u0015\u0004A\u0002\u0019\u000b!\u0002^3na2\fG/Z%e\u0011\u0015!f\u00011\u0001G\u0003\u001d1XM]:j_:DQA\u0016\u0004A\u0002\u0019\u000b1\u0002Z3tGJL\u0007\u000f^5p]\")\u0001L\u0002a\u0001\r\u0006!Qo]3sQ\t\u0001!\f\u0005\u0002\\=6\tAL\u0003\u0002^}\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\u0005}c&!C\"p[B|g.\u001a8u\u0001")
public class ScmTemplateStorageService {
    private final ScmConnectorService scmConnectorService;
    private final ScmTemplateToBlobsConverter scmTemplateToBlobsConverter;
    private final ReleaseService releaseService;
    private final UserProfileService userProfileService;

    public String createNewVersion(String templateId, String version, String description, String user) {
        Release template = this.releaseService.findById(templateId);
        ScmConnectorConfig scmConfiguration = this.scmConnectorService.findScmConnectorConfig(template.getId());
        ScmConnector scmConnector = scmConfiguration.getConnector();
        Blobs blobs = this.scmTemplateToBlobsConverter.convertTemplate(template);
        String identifier = scmConnector.getIdentifier(blobs);
        ValidatedCommitInfo commitInfo = (ValidatedCommitInfo)ValidatedCommitInfo$.MODULE$.create(version, description, identifier).get();
        UserProfile userProfile = this.userProfileService.findByUsername(user);
        scmConnector.createNewVersion(blobs, commitInfo, userProfile).get();
        return commitInfo.tag().refName();
    }

    @Autowired
    public ScmTemplateStorageService(ScmConnectorService scmConnectorService, ScmTemplateToBlobsConverter scmTemplateToBlobsConverter, ReleaseService releaseService, UserProfileService userProfileService) {
        this.scmConnectorService = scmConnectorService;
        this.scmTemplateToBlobsConverter = scmTemplateToBlobsConverter;
        this.releaseService = releaseService;
        this.userProfileService = userProfileService;
    }
}

