/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.templates;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext$;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.scm.connector.ScmConnectorConfig;
import com.xebialabs.xlrelease.dsl.service.DslExporter;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.scm.connector.ScmConnectorService;
import com.xebialabs.xlrelease.scm.connector.ScmException;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.versioning.scm.ScmTemplateStorageService;
import com.xebialabs.xlrelease.versioning.templates.CreateVersionResponse;
import com.xebialabs.xlrelease.versioning.templates.CreateVersionResponse$;
import com.xebialabs.xlrelease.versioning.templates.TemplateStorageService;
import com.xebialabs.xlrelease.versioning.templates.actors.extensions.TemplateVersionExtensionActorMessages;
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings;
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings$;
import com.xebialabs.xlrelease.versioning.templates.repository.TemplateRevisionRepository;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevision;
import com.xebialabs.xlrelease.versioning.templates.views.TemplateContentAndPrevious;
import com.xebialabs.xlrelease.versioning.templates.views.VersionView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Try;
import scala.util.Try$;

@Path(value="/versioning")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\tmg\u0001\u0002\f\u0018\u0001\tB\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011!i\u0005A!A!\u0002\u0013q\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011i\u0003!\u0011!Q\u0001\nmC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tO\u0002\u0011\t\u0011)A\u0005Q\")q\u000e\u0001C\u0001a\"9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001bBA'\u0001\u0011\u0005\u0011q\n\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u001d\t\t\f\u0001C\u0001\u0003gCq!!5\u0001\t\u0003\t\u0019\u000eC\u0004\u0002z\u0002!\t!a?\t\u000f\tU\u0001\u0001\"\u0001\u0003\u0018!9!\u0011\u0007\u0001\u0005\u0002\tM\u0002b\u0002B*\u0001\u0011\u0005!Q\u000b\u0005\b\u0005\u0017\u0003A\u0011\u0002BG\u0011\u001d\u0011i\n\u0001C\u0005\u0005?\u0013!\u0004V3na2\fG/\u001a,feNLwN\\5oOJ+7o\\;sG\u0016T!\u0001G\r\u0002\u0013Q,W\u000e\u001d7bi\u0016\u001c(B\u0001\u000e\u001c\u0003)1XM]:j_:Lgn\u001a\u0006\u00039u\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005yy\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005\u0001\u0013aA2p[\u000e\u00011c\u0001\u0001$SA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u000bMdg\r\u000e6\u000b\u00039\n\u0001b\u001a:jujdW\rZ\u0005\u0003a-\u0012q\u0001T8hO&tw-A\u0006eg2,\u0005\u0010]8si\u0016\u0014\bCA\u001a9\u001b\u0005!$BA\u001b7\u0003\u001d\u0019XM\u001d<jG\u0016T!aN\u000e\u0002\u0007\u0011\u001cH.\u0003\u0002:i\tYAi\u001d7FqB|'\u000f^3s\u0003i!X-\u001c9mCR,'+\u001a<jg&|gNU3q_NLGo\u001c:z!\tat(D\u0001>\u0015\tqt#\u0001\u0006sKB|7/\u001b;pefL!\u0001Q\u001f\u00035Q+W\u000e\u001d7bi\u0016\u0014VM^5tS>t'+\u001a9pg&$xN]=\u0002-Q,W\u000e\u001d7bi\u0016\u001cFo\u001c:bO\u0016\u001cVM\u001d<jG\u0016\u0004\"a\u0011#\u000e\u0003]I!!R\f\u0003-Q+W\u000e\u001d7bi\u0016\u001cFo\u001c:bO\u0016\u001cVM\u001d<jG\u0016\f1C]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\u0004\"\u0001S&\u000e\u0003%S!AS\u000e\u0002\r\u0005\u001cGo\u001c:t\u0013\ta\u0015JA\nSK2,\u0017m]3BGR|'oU3sm&\u001cW-A\tqKJl\u0017n]:j_:\u001c\u0005.Z2lKJ\u0004\"a\u0014*\u000e\u0003AS!!U\u000e\u0002\u0011M,7-\u001e:jifL!a\u0015)\u0003#A+'/\\5tg&|gn\u00115fG.,'/\u0001\bsK2,\u0017m]3TKJ4\u0018nY3\u0011\u0005YCV\"A,\u000b\u0005UZ\u0012BA-X\u00059\u0011V\r\\3bg\u0016\u001cVM\u001d<jG\u0016\fqcY8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0011\u0005qsV\"A/\u000b\u0005yZ\u0012BA0^\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u00180A\fuK6\u0004H.\u0019;f'R|'/Y4f\u0019&\u001cH/\u001a8feB\u0011!-Z\u0007\u0002G*\u0011A-G\u0001\u0004g\u000el\u0017B\u00014d\u0005e\u00196-\u001c+f[Bd\u0017\r^3Ti>\u0014\u0018mZ3TKJ4\u0018nY3\u0002'M\u001cWnQ8o]\u0016\u001cGo\u001c:TKJ4\u0018nY3\u0011\u0005%lW\"\u00016\u000b\u0005-d\u0017!C2p]:,7\r^8s\u0015\t!7$\u0003\u0002oU\n\u00192kY7D_:tWm\u0019;peN+'O^5dK\u00061A(\u001b8jiz\"\"\"\u001d:tiV4x\u000f_={!\t\u0019\u0005\u0001C\u00032\u0015\u0001\u0007!\u0007C\u0003;\u0015\u0001\u00071\bC\u0003B\u0015\u0001\u0007!\tC\u0003G\u0015\u0001\u0007q\tC\u0003N\u0015\u0001\u0007a\nC\u0003U\u0015\u0001\u0007Q\u000bC\u0003[\u0015\u0001\u00071\fC\u0003a\u0015\u0001\u0007\u0011\rC\u0003h\u0015\u0001\u0007\u0001\u000e\u000b\u0002\u000byB\u0019Q0!\u0005\u000e\u0003yT1a`A\u0001\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003\u0007\t)!A\u0004gC\u000e$xN]=\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0006E\u0016\fgn\u001d\u0006\u0005\u0003\u0017\ti!A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\ty!A\u0002pe\u001eL1!a\u0005\u007f\u0005%\tU\u000f^8xSJ,G-\u0001\u0010hKR$V-\u001c9mCR,g+\u001a:tS>tw.\u001b8h'\u0016$H/\u001b8hgV\u0011\u0011\u0011\u0004\t\u0005\u00037\t)#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u0019!w.\\1j]*\u0019\u00111E\f\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\u0011\t9#!\b\u00035Q+W\u000e\u001d7bi\u00164VM]:j_:LgnZ*fiRLgnZ:)\u000f-\tY#a\u0010\u0002BA!\u0011QFA\u001e\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012A\u0001:t\u0015\u0011\t)$a\u000e\u0002\u0005]\u001c(BAA\u001d\u0003\u0015Q\u0017M^1y\u0013\u0011\ti$a\f\u0003\tA\u000bG\u000f[\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u0007\n\u0011bL:fiRLgnZ:)\u0007-\t9\u0005\u0005\u0003\u0002.\u0005%\u0013\u0002BA&\u0003_\u00111aR#U\u00039\u0019wN\u001c8fGRLwN\\%oM>$B!!\u0015\u0002^A!\u00111KA-\u001b\t\t)F\u0003\u0003\u0002X\u0005=\u0012\u0001B2pe\u0016LA!a\u0017\u0002V\tA!+Z:q_:\u001cX\rC\u0004\u0002`1\u0001\r!!\u0019\u0002\u0015Q,W\u000e\u001d7bi\u0016LE\r\u0005\u0003\u0002d\u0005Ed\u0002BA3\u0003[\u00022!a\u001a&\u001b\t\tIGC\u0002\u0002l\u0005\na\u0001\u0010:p_Rt\u0014bAA8K\u00051\u0001K]3eK\u001aLA!a\u001d\u0002v\t11\u000b\u001e:j]\u001eT1!a\u001c&Q\u0011\ti&!\u001f\u0011\t\u0005m\u0014\u0011R\u0007\u0003\u0003{RA!a \u0002\u0002\u0006\u0011\u0011\u000e\u001a\u0006\u0005\u0003\u0007\u000b))\u0001\u0005qYVl'-\u001b8h\u0015\r\t9)H\u0001\tI\u0016\u0004Hn\\=ji&!\u00111RA?\u0005\u001dIE\rU1sC6D\u0003\"!\u0018\u0002\u0010\u0006}\u0012Q\u0013\t\u0005\u0003[\t\t*\u0003\u0003\u0002\u0014\u0006=\"!\u0003)bi\"\u0004\u0016M]1nC\t\ty\u0006K\u0004\r\u0003W\ty$!'\"\u0005\u0005m\u0015aK>uK6\u0004H.\u0019;f\u0013\u0012TdF\u000b*fY\u0016\f7/Z.__5j&&`\u0018d_:tWm\u0019;j_:LeNZ8)\u00071\t9%\u0001\u0007hKR\u0014VM^5tS>t7\u000f\u0006\u0003\u0002R\u0005\r\u0006bBA0\u001b\u0001\u0007\u0011\u0011\r\u0015\u0005\u0003G\u000bI\b\u000b\u0005\u0002$\u0006=\u0015qHAKQ\u001di\u00111FA \u0003W\u000b#!!,\u0002O=ZH/Z7qY\u0006$X-\u00133;])\u0012V\r\\3bg\u0016\\flL\u0017^Uu|#/\u001a<jg&|gn\u001d\u0015\u0004\u001b\u0005\u001d\u0013AE4fiJ+g/[:j_:\u001cuN\u001c;f]R$b!!\u0015\u00026\u0006m\u0006bBA0\u001d\u0001\u0007\u0011\u0011\r\u0015\u0005\u0003k\u000bI\b\u000b\u0005\u00026\u0006=\u0015qHAK\u0011\u001d\tiL\u0004a\u0001\u0003\u007f\u000b!B]3wSNLwN\\%e!\r!\u0013\u0011Y\u0005\u0004\u0003\u0007,#aA%oi\"B\u00111XAH\u0003\u007f\t9-\t\u0002\u0002>\":a\"a\u000b\u0002@\u0005-\u0017EAAg\u0003qz3\u0010^3na2\fG/Z%eu9R#+\u001a7fCN,7LX\u0018.;*jxF]3wSNLwN\\:0wJ,g/[:j_:LE-`\u0018d_:$XM\u001c;)\u00079\t9%A\u0007de\u0016\fG/\u001a,feNLwN\u001c\u000b\u0007\u0003#\n).a7\t\u000f\u0005}s\u00021\u0001\u0002b!\"\u0011Q[A=Q!\t).a$\u0002@\u0005U\u0005bBAo\u001f\u0001\u0007\u0011q\\\u0001\fm\u0016\u00148/[8o-&,w\u000f\u0005\u0003\u0002b\u0006\u001dXBAAr\u0015\r\t)oF\u0001\u0006m&,wo]\u0005\u0005\u0003S\f\u0019OA\u0006WKJ\u001c\u0018n\u001c8WS\u0016<\bfB\b\u0002,\u0005}\u0012Q^\u0011\u0003\u0003_\faeL>uK6\u0004H.\u0019;f\u0013\u0012TdF\u000b*fY\u0016\f7/Z.__5j&&`\u0018wKJ\u001c\u0018n\u001c8tQ\ry\u00111\u001f\t\u0005\u0003[\t)0\u0003\u0003\u0002x\u0006=\"\u0001\u0002)P'R\u000bqB]3ti>\u0014XMU3wSNLwN\u001c\u000b\u0007\u0003#\niPa\u0001\t\u000f\u0005}\u0003\u00031\u0001\u0002b!\"\u0011Q`A=Q!\ti0a$\u0002@\u0005U\u0005bBA_!\u0001\u0007\u0011q\u0018\u0015\t\u0005\u0007\ty)a\u0010\u0002H\":\u0001#a\u000b\u0002@\t%\u0011E\u0001B\u0006\u0003qz3\u0010^3na2\fG/Z%eu9R#+\u001a7fCN,7LX\u0018.;*jxF]3wSNLwN\\:0wJ,g/[:j_:LE-`\u0018sKN$xN]3)\u0007A\u0011y\u0001\u0005\u0003\u0002.\tE\u0011\u0002\u0002B\n\u0003_\u00111\u0001U+U\u00039!W\r\\3uKJ+g/[:j_:$b!!\u0015\u0003\u001a\t}\u0001bBA0#\u0001\u0007\u0011\u0011\r\u0015\u0005\u00053\tI\b\u000b\u0005\u0003\u001a\u0005=\u0015qHAK\u0011\u001d\ti,\u0005a\u0001\u0003\u007fC\u0003Ba\b\u0002\u0010\u0006}\u0012q\u0019\u0015\b#\u0005-\u0012q\bB\u0013C\t\u00119#\u0001\u001b0wR,W\u000e\u001d7bi\u0016LEM\u000f\u0018+%\u0016dW-Y:f7z{S&\u0018\u0016~_I,g/[:j_:\u001cxf\u001f:fm&\u001c\u0018n\u001c8JIvD3!\u0005B\u0016!\u0011\tiC!\f\n\t\t=\u0012q\u0006\u0002\u0007\t\u0016cU\tV#\u0002\u001f\u0011,G.\u001a;f%\u00164\u0018n]5p]N$b!!\u0015\u00036\tm\u0002bBA0%\u0001\u0007\u0011\u0011\r\u0015\u0005\u0005k\tI\b\u000b\u0005\u00036\u0005=\u0015qHAK\u0011\u001d\u0011iD\u0005a\u0001\u0005\u007f\t1B]3wSNLwN\\%egB1!\u0011\tB&\u0003\u007fk!Aa\u0011\u000b\t\t\u0015#qI\u0001\u0005kRLGN\u0003\u0002\u0003J\u0005!!.\u0019<b\u0013\u0011\u0011iEa\u0011\u0003\t1K7\u000f\u001e\u0015\b%\u0005-\u0012qHAVQ\r\u0011\"1F\u0001\bG>l\u0007/\u0019:f)!\u00119F!\u0018\u0003d\te\u0004\u0003BAq\u00053JAAa\u0017\u0002d\nQB+Z7qY\u0006$XmQ8oi\u0016tG/\u00118e!J,g/[8vg\"9\u0011qL\nA\u0002\u0005\u0005\u0004\u0006\u0002B/\u0003sB\u0003B!\u0018\u0002\u0010\u0006}\u0012Q\u0013\u0005\b\u0003{\u001b\u0002\u0019AA`Q!\u0011\u0019Ga\u001a\u0002@\u0005\u001d\u0007\u0003BA\u0017\u0005SJAAa\u001b\u00020\tQ\u0011+^3ssB\u000b'/Y7)\u0011\t\r$qNA \u0005k\u0002B!!\f\u0003r%!!1OA\u0018\u00051!UMZ1vYR4\u0016\r\\;fC\t\u00119(A\u00011\u0011\u001d\u0011Yh\u0005a\u0001\u0003\u007f\u000bA\u0002^8SKZL7/[8o\u0013\u0012D\u0003B!\u001f\u0003h\u0005}\"qP\u0011\u0003\u0005wB\u0003B!\u001f\u0003p\u0005}\"Q\u000f\u0015\b'\u0005-\u0012q\bBCC\t\u00119)A\u00130wR,W\u000e\u001d7bi\u0016LEM\u000f\u0018+%\u0016dW-Y:f7z{S&\u0018\u0016~_\r|W\u000e]1sK\"\u001a1#a\u0012\u0002)\u001d,GOU3t_2,H/[8o\u0007>tG/\u001a=u)\u0011\u0011yIa'\u0011\t\tE%qS\u0007\u0003\u0005'SAA!&\u0002\u0002\u0006i1/\u001a:jC2L'0\u0019;j_:LAA!'\u0003\u0014\n\t\"+Z:pYV$\u0018n\u001c8D_:$X\r\u001f;\t\u000f\u0005}C\u00031\u0001\u0002b\u0005\u0001r-\u001a;UK6\u0004H.\u0019;f\u0003N$5\u000f\u001c\u000b\u0005\u0003C\u0012\t\u000bC\u0004\u0003$V\u0001\rA!*\u0002\u0011Q,W\u000e\u001d7bi\u0016\u0004BAa*\u0003,6\u0011!\u0011\u0016\u0006\u0004\u0003?Y\u0012\u0002\u0002BW\u0005S\u0013qAU3mK\u0006\u001cX\rK\u0002\u0001\u0005c\u0003BAa-\u0003:6\u0011!Q\u0017\u0006\u0005\u0005o\u000bI!\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAAa/\u00036\nQ1i\u001c8ue>dG.\u001a:)\u000f\u0001\u0011y,a\u0010\u0003FB!\u0011Q\u0006Ba\u0013\u0011\u0011\u0019-a\f\u0003\u0011\r{gn];nKNd#Aa2\"\u0005\t%\u0017\u0001E1qa2L7-\u0019;j_:|#n]8oQ\u001d\u0001!QZA \u0005'\u0004B!!\f\u0003P&!!\u0011[A\u0018\u0005!\u0001&o\u001c3vG\u0016\u001cHF\u0001BdQ\u001d\u0001\u00111FA \u0005/\f#A!7\u0002\u0017=2XM]:j_:Lgn\u001a")
public class TemplateVersioningResource
implements Logging {
    private final DslExporter dslExporter;
    private final TemplateRevisionRepository templateRevisionRepository;
    private final TemplateStorageService templateStorageService;
    private final ReleaseActorService releaseActorService;
    private final PermissionChecker permissionChecker;
    private final ReleaseService releaseService;
    private final ConfigurationRepository configurationRepository;
    private final ScmTemplateStorageService templateStorageListener;
    private final ScmConnectorService scmConnectorService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TemplateVersioningResource templateVersioningResource = this;
        synchronized (templateVersioningResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @GET
    @Path(value="/settings")
    public TemplateVersioningSettings getTemplateVersionoingSettings() {
        return (TemplateVersioningSettings)this.configurationRepository.read(TemplateVersioningSettings$.MODULE$.TEMPLATE_VERSIONING_ID());
    }

    @GET
    @Path(value="{templateId:.*Release[^/-]*}/connectionInfo")
    public Response connectionInfo(@PathParam(value="templateId") @IdParam String templateId) {
        String folderId = Ids.findFolderId((String)templateId);
        ScmConnectorConfig scmConfiguration = this.scmConnectorService.findScmConnectorConfig(folderId);
        return Response.ok((Object)scmConfiguration).build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/revisions")
    public Response getRevisions(@PathParam(value="templateId") @IdParam String templateId) {
        this.permissionChecker.checkView(templateId);
        List<TemplateRevision> templateRevisions = this.templateRevisionRepository.find(templateId, new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4()));
        GenericEntity<List<TemplateRevision>> entity = new GenericEntity<List<TemplateRevision>>(null, templateRevisions){};
        return Response.ok((Object)entity).build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}/content")
    public Response getRevisionContent(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        this.permissionChecker.checkView(templateId);
        Release template = this.templateStorageService.load(revisionId, this.getResolutionContext(templateId));
        return Response.ok((Object)this.getTemplateAsDsl(template), (String)"text/plain").build();
    }

    @POST
    @Path(value="/{templateId:.*Release[^/-]*}/versions")
    public Response createVersion(@PathParam(value="templateId") @IdParam String templateId, VersionView versionView) {
        Checks.checkArgument((boolean)this.releaseService.isTemplate(templateId), (String)"Snapshots can only be created for templates", (Object[])new Object[0]);
        this.permissionChecker.checkEdit(templateId);
        String user = Permissions.getAuthenticatedUserName();
        Try result = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.templateStorageListener.createNewVersion(templateId, versionView.name(), versionView.description(), user)).map((Function1 & Serializable)tagName -> {
            Try r = (Try)$this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new TemplateVersionExtensionActorMessages.NewTemplateVersion((String)tagName, versionView.description(), user));
            return new Tuple2(tagName, (Object)r);
        }).map((Function1 & Serializable)x$1 -> {
            Try try_;
            Try r;
            Tuple2 tuple2 = x$1;
            if (tuple2 == null || (r = (Try)tuple2._2()) == null) {
                throw new MatchError((Object)tuple2);
            }
            Try try_2 = try_ = r;
            return try_2;
        });
        return Response.ok((Object)result.fold((Function1 & Serializable)x0$1 -> {
            CreateVersionResponse createVersionResponse;
            Throwable throwable = x0$1;
            if (throwable instanceof ScmException) {
                ScmException scmException = (ScmException)throwable;
                String msg = scmException.msg();
                int statusCode = scmException.statusCode();
                this.logger().warn((Function0 & Serializable)() -> "Unable to create a new version of a template.", (Function0 & Serializable)() -> scmException);
                createVersionResponse = new CreateVersionResponse(false, msg, statusCode);
            } else if (throwable != null) {
                Throwable throwable2 = throwable;
                this.logger().warn((Function0 & Serializable)() -> "Unable to create a new version of a template.", (Function0 & Serializable)() -> throwable2);
                createVersionResponse = new CreateVersionResponse(false, throwable2.getMessage(), 500);
            } else {
                throw new MatchError((Object)throwable);
            }
            return createVersionResponse;
        }, (Function1 & Serializable)id -> new CreateVersionResponse(true, id.toString(), CreateVersionResponse$.MODULE$.$lessinit$greater$default$3()))).build();
    }

    @PUT
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}/restore")
    public Response restoreRevision(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        this.permissionChecker.check(XLReleasePermissions.EDIT_TEMPLATE, templateId);
        this.permissionChecker.check(XLReleasePermissions.CREATE_RELEASE_FROM_TEMPLATE, templateId);
        this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new TemplateVersionExtensionActorMessages.RestoreRevision(revisionId));
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}")
    public Response deleteRevision(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        this.permissionChecker.checkEdit(templateId);
        this.templateStorageService.deleteRevision(templateId, revisionId);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{templateId:.*Release[^/-]*}/revisions")
    public Response deleteRevisions(@PathParam(value="templateId") @IdParam String templateId, List<Object> revisionIds) {
        this.permissionChecker.checkEdit(templateId);
        this.templateStorageService.deleteRevisions(templateId, (Seq<Object>)CollectionConverters$.MODULE$.ListHasAsScala(revisionIds).asScala().toSeq());
        return Response.ok().build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/compare")
    public TemplateContentAndPrevious compare(@PathParam(value="templateId") @IdParam String templateId, @DefaultValue(value="0") @QueryParam(value="revisionId") int revisionId, @DefaultValue(value="0") @QueryParam(value="toRevisionId") int toRevisionId) {
        this.permissionChecker.checkView(templateId);
        Release revision = revisionId == 0 ? this.releaseService.findById(templateId) : this.templateStorageService.load(revisionId, this.getResolutionContext(templateId));
        Release toRevision = toRevisionId == 0 ? this.releaseService.findById(templateId) : this.templateStorageService.load(toRevisionId, this.getResolutionContext(templateId));
        return new TemplateContentAndPrevious(this.getTemplateAsDsl(revision), this.getTemplateAsDsl(toRevision));
    }

    private ResolutionContext getResolutionContext(String templateId) {
        return Ids.isInFolder((String)templateId) ? ResolutionContext$.MODULE$.apply(Ids.getParentId((String)templateId)) : ResolutionContext$.MODULE$.GLOBAL();
    }

    private String getTemplateAsDsl(Release template) {
        return this.dslExporter.exportTemplate(template, this.dslExporter.exportTemplate$default$2());
    }

    @Autowired
    public TemplateVersioningResource(DslExporter dslExporter, TemplateRevisionRepository templateRevisionRepository, TemplateStorageService templateStorageService, ReleaseActorService releaseActorService, PermissionChecker permissionChecker, ReleaseService releaseService, ConfigurationRepository configurationRepository, ScmTemplateStorageService templateStorageListener, ScmConnectorService scmConnectorService) {
        this.dslExporter = dslExporter;
        this.templateRevisionRepository = templateRevisionRepository;
        this.templateStorageService = templateStorageService;
        this.releaseActorService = releaseActorService;
        this.permissionChecker = permissionChecker;
        this.releaseService = releaseService;
        this.configurationRepository = configurationRepository;
        this.templateStorageListener = templateStorageListener;
        this.scmConnectorService = scmConnectorService;
        Logging.$init$((Logging)this);
    }
}

