package com.xebialabs.xlrelease.versioning.templates.configuration.domain

import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlrelease.domain.BaseSettings

@Metadata(root = CONFIGURATION, versioned = false, label = "Template Version control (Not recommended)", description = "Release will use these settings to enable automatic versioning of templates. Settings will take effect after 1 minute. Note: This feature is deprecated and has been superseded by Folder versioning.")
class TemplateVersioningSettings extends BaseSettings {

  @Property(defaultValue = "false", required = false, label = "Enable automatic saving of a new version after template changes")
  var enableAutomatedVersioning: Boolean = _

  @Property(defaultValue = "template", hidden = true)
  var displayIcon: String = _

  @Property(defaultValue = "general-settings", hidden = true)
  var displayPage: String = _

  @Property(defaultValue = "70", hidden = true)
  var weight: Integer = _

  @Property(defaultValue = "true", hidden = true, label = "Note: Template version control feature is being deprecated. It is replaced by 'GitOps enabled version control'.")
  var deprecated: Boolean = _

}

object TemplateVersioningSettings {
  val TEMPLATE_VERSIONING_ID: String = BaseSettings.BASE_ID + "TemplateVersioningSettings"
}

object VersioningSettings {
  var automaticChangesEnabled: Boolean = false
}
